/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.config;

import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class NewConfigExample {
    public static final ForgeConfigSpec GENERAL_SPEC;
    public static ForgeConfigSpec.IntValue exampleIntConfigEntry;
    public static ForgeConfigSpec.DoubleValue exampleDoubleConfigEntry;
    public static ForgeConfigSpec.ConfigValue<Double> exampleUnboundedDoubleConfigEntry;
    public static ForgeConfigSpec.LongValue exampleLongConfigEntry;
    public static ForgeConfigSpec.BooleanValue exampleBooleanConfigEntry;
    public static ForgeConfigSpec.ConfigValue<String> exampleStringConfigEntry;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> exampleStringListConfigEntry;

    private static void setupConfig(ForgeConfigSpec.Builder builder) {
        builder.comment(" This category holds configs that uses numbers.");
        builder.push("Numeric Config Options");
        exampleIntConfigEntry = builder.defineInRange("example_int_config_entry", 5, 2, 50);
        exampleDoubleConfigEntry = builder.defineInRange("example_double_config_entry", 10.0, 0.0, 100.0);
        exampleUnboundedDoubleConfigEntry = builder.comment("This comment will be attached to example_unbounded_double_config_entry in the config file.").define("example_unbounded_double_config_entry", (Object)1000.0);
        exampleLongConfigEntry = builder.defineInRange("example_long_config_entry", 4L, -900L, 900L);
        builder.pop();
        builder.comment(" This category holds configs that uses numbers.");
        builder.push("String Config Options");
        exampleStringConfigEntry = builder.comment("This config holds a single string.").define("example_string_config_entry", (Object)"player444");
        builder.comment(" This category will be nested inside the String Config Options category.");
        builder.push("Nested Category");
        exampleStringListConfigEntry = builder.comment("This config entry will hold a list of strings.").defineList("example_string_list_config_entry", Arrays.asList("pie", "trains"), entry -> true);
        builder.pop();
        builder.pop();
    }

    static {
        ForgeConfigSpec.Builder configBuilder = new ForgeConfigSpec.Builder();
        NewConfigExample.setupConfig(configBuilder);
        GENERAL_SPEC = configBuilder.build();
    }
}

