/*
 * Decompiled with CFR 0.152.
 */
package alpvax.mc.goprone.config;

import alpvax.mc.goprone.config.ConfigException;
import alpvax.mc.goprone.config.ConfigResult;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigSetting {
    private final String key;
    private final boolean defaultValue;
    private final String[] configComment;
    private final Predicate<Player> predicate;
    private final Set<ConfigException<?, ?>> exceptions = new HashSet();
    private ForgeConfigSpec.ConfigValue<Boolean> configValue;
    private boolean value;

    public ConfigSetting(String key, boolean defaultVal, Predicate<Player> predicate, String ... comment) {
        String[] stringArray;
        this.key = key;
        this.defaultValue = defaultVal;
        this.value = defaultVal;
        if (comment.length < 1) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "Set to true if going prone should be allowed in this scenario, false otherwise";
        } else {
            stringArray = comment;
        }
        this.configComment = stringArray;
        this.predicate = predicate;
    }

    public void createConfigValue(ForgeConfigSpec.Builder builder) {
        builder.comment(this.configComment);
        if (this.exceptions.size() < 1) {
            this.configValue = this.addConfigValue(this.key, builder);
        } else {
            builder.push(this.key);
            this.configValue = this.addConfigValue("allowed", builder);
            this.addExceptionConfigValues(builder);
            builder.pop();
        }
    }

    protected ForgeConfigSpec.ConfigValue<Boolean> addConfigValue(String key, ForgeConfigSpec.Builder builder) {
        return builder.define(key, this.defaultValue);
    }

    protected void addExceptionConfigValues(ForgeConfigSpec.Builder builder) {
        this.exceptions.forEach(e -> e.createConfigValue(builder));
    }

    public <T, C> ConfigSetting withException(ConfigException<T, C> exception) {
        if (this.configValue != null) {
            throw new IllegalArgumentException("Config exceptions must be added before the config is generated!");
        }
        this.exceptions.add(exception.setParent(this.key));
        return this;
    }

    protected void bakeConfigValue() {
        this.value = (Boolean)this.configValue.get();
        this.exceptions.forEach(ConfigException::bakeValue);
    }

    public ConfigResult test(Player player) {
        return this.predicate.test(player) ? (this.value != this.exceptions.stream().anyMatch(e -> e.test(player)) ? ConfigResult.ALLOW : ConfigResult.DENY) : ConfigResult.PASS;
    }
}

