/*
 * Decompiled with CFR 0.152.
 */
package alpvax.mc.goprone;

import alpvax.mc.goprone.validation.Checks;
import alpvax.mc.goprone.validation.RidingCheck;
import java.util.EnumSet;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerProneData {
    public static Capability<PlayerProneData> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerProneData>(){});
    @NotNull
    Player player;
    private boolean shouldBeProne;
    private final EnumSet<Checks> failedChecks = EnumSet.noneOf(Checks.class);
    private boolean dirty = false;
    @Nullable
    private EntityType<?> prevRiding;

    public PlayerProneData(@NotNull Player player) {
        this.player = player;
        Entity riding = player.m_20202_();
        this.prevRiding = riding == null ? null : riding.m_6095_();
    }

    void markDirty() {
        this.dirty = true;
    }

    public void setProne(boolean prone) {
        this.shouldBeProne = prone;
        this.updateProneState();
    }

    private void setRiding(@Nullable EntityType<?> riding) {
        this.prevRiding = riding;
        if (riding == null || RidingCheck.checkEntityType(riding) ? this.failedChecks.remove((Object)Checks.RIDING) : this.failedChecks.add(Checks.RIDING)) {
            this.markDirty();
        }
    }

    protected void playerTick() {
        Entity riding;
        if (Checks.CLIMBING.updateFailed(this.player.m_6147_(), this.failedChecks)) {
            this.markDirty();
        }
        if (Checks.FLYING.updateFailed(!this.player.m_20096_(), this.failedChecks)) {
            this.markDirty();
        }
        if ((riding = this.player.m_20202_()) != null) {
            EntityType t = this.player.m_20202_().m_6095_();
            if (t != this.prevRiding) {
                this.setRiding(t);
            }
        } else if (this.prevRiding != null) {
            this.setRiding(null);
        }
        if (this.dirty) {
            this.updateProneState();
        }
    }

    private void updateProneState() {
        if (this.shouldBeProne && this.failedChecks.isEmpty()) {
            this.player.setForcedPose(Pose.SWIMMING);
        } else {
            this.player.setForcedPose(null);
        }
        this.dirty = false;
    }

    static class Provider
    implements ICapabilityProvider {
        private final PlayerProneData data;
        private final LazyOptional<PlayerProneData> holder;

        public Provider(Player player) {
            this.data = new PlayerProneData(player);
            this.holder = LazyOptional.of(() -> this.data);
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            return CAPABILITY.orEmpty(cap, this.holder);
        }
    }
}

