/*
 * Decompiled with CFR 0.152.
 */
package alpvax.mc.goprone;

import alpvax.mc.goprone.PlayerProneData;
import alpvax.mc.goprone.network.PacketHandler;
import alpvax.mc.goprone.network.SetPronePacket;
import com.mojang.blaze3d.platform.InputConstants;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.ConnectionData;
import net.minecraftforge.network.NetworkHooks;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="goprone")
public class ClientProxy {
    public static final KeyMapping prone = new KeyMapping("key.prone", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 67, "key.categories.movement"){

        public void m_7249_(boolean down) {
            super.m_7249_(down);
            ClientProxy.sendUpdate();
        }
    };
    public static final AlwaysToggleMapping toggleProne = new AlwaysToggleMapping("key.prone.toggle", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.f_84822_, "key.categories.movement");
    private static boolean serverSideExists = false;

    public static void init(RegisterKeyMappingsEvent event) {
        event.register(prone);
        event.register((KeyMapping)toggleProne);
    }

    public static void setToggleState(boolean toggleState) {
        toggleProne.setToggle(toggleState);
    }

    private static void sendUpdate() {
        if (ClientProxy.isDisabled()) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            boolean shouldBeProne = prone.m_90857_() != toggleProne.m_90857_();
            PacketHandler.sendToServer(new SetPronePacket(shouldBeProne));
            player.getCapability(PlayerProneData.CAPABILITY).ifPresent(data -> data.setProne(shouldBeProne));
        }
    }

    @SubscribeEvent
    public static void onServerConnect(ClientPlayerNetworkEvent.LoggingIn event) {
        ConnectionData connection = NetworkHooks.getConnectionData((Connection)event.getConnection());
        boolean bl = serverSideExists = connection != null && connection.getModList().contains((Object)"goprone");
        if (!serverSideExists) {
            event.getPlayer().m_5661_((Component)Component.m_237115_((String)"goprone.notinstalled").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.RED}), false);
        }
    }

    @SubscribeEvent
    public static void attachCapabilityClient(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof LocalPlayer) {
            LocalPlayer player = (LocalPlayer)object;
            event.addCapability(new ResourceLocation("goprone", "player_cap"), (ICapabilityProvider)new PlayerProneData.Provider((Player)player));
        }
    }

    public static boolean isDisabled() {
        return !serverSideExists;
    }

    public static void onConfigChange() {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            player.getCapability(PlayerProneData.CAPABILITY).ifPresent(PlayerProneData::markDirty);
        }
    }

    private static class AlwaysToggleMapping
    extends KeyMapping {
        public AlwaysToggleMapping(String description, IKeyConflictContext keyConflictContext, InputConstants.Key keyCode, String category) {
            super(description, keyConflictContext, keyCode, category);
        }

        public void m_7249_(boolean down) {
            if (down && this.isConflictContextAndModifierActive()) {
                super.m_7249_(!this.m_90857_());
                ClientProxy.sendUpdate();
            }
        }

        private void setToggle(boolean down) {
            super.m_7249_(down);
        }
    }
}

