/*
 * Decompiled with CFR 0.152.
 */
package alpvax.mc.goprone;

import alpvax.mc.goprone.ClientProxy;
import alpvax.mc.goprone.PlayerProneData;
import alpvax.mc.goprone.config.ConfigOptions;
import alpvax.mc.goprone.network.PacketHandler;
import alpvax.mc.goprone.validation.RidingCheck;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="goprone")
public class GoProne {
    public static final String MODID = "goprone";
    private static final Logger LOGGER = LogManager.getLogger();

    public GoProne() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        PacketHandler.register();
        ConfigOptions.registerConfig(ModLoadingContext.get());
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> modBus.addListener(ClientProxy::init));
        modBus.addListener(ConfigOptions::onModConfigEvent);
        modBus.addListener(this::registerCapability);
        modBus.addListener(this::gatherData);
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "ANY", (remote, isServer) -> true));
    }

    public static void onConfigChange() {
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientProxy::onConfigChange);
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            server.m_6846_().m_11314_().forEach(p -> p.getCapability(PlayerProneData.CAPABILITY).ifPresent(PlayerProneData::markDirty));
        }
    }

    private void registerCapability(RegisterCapabilitiesEvent event) {
        event.register(PlayerProneData.class);
    }

    @SubscribeEvent
    public void attachPlayerCapability(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)object;
            event.addCapability(new ResourceLocation(MODID, "player_cap"), (ICapabilityProvider)new PlayerProneData.Provider((Player)player));
        }
    }

    @SubscribeEvent
    public void clonePlayer(PlayerEvent.Clone event) {
        LOGGER.debug((Object)event.getOriginal().getCapability(PlayerProneData.CAPABILITY));
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            event.player.getCapability(PlayerProneData.CAPABILITY).ifPresent(PlayerProneData::playerTick);
            this.onPlayerSprint(event.player);
        }
    }

    public void onPlayerSprint(Player player) {
        if (player.getForcedPose() == Pose.SWIMMING && !ConfigOptions.instance().sprintingAllowed.get()) {
            player.m_6858_(false);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        Player player;
        Boolean disabled;
        if (event.getEntity().f_19853_.f_46443_ && (disabled = (Boolean)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> ClientProxy::isDisabled)) != null && disabled.booleanValue()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_20096_() && player.m_20089_() == Pose.SWIMMING && !ConfigOptions.instance().jumpingAllowed.get()) {
            Vec3 motion = player.m_20184_();
            player.m_20334_(motion.f_82479_, 0.0, motion.f_82481_);
        }
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        gen.addProvider(event.includeServer(), (DataProvider)new RidingCheck.TagsProvider(packOutput, lookupProvider, event.getExistingFileHelper()));
    }
}

