/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu.goprone;

import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Config {
    public static final transient Logger LOG = LogManager.getLogger((String)"GoProne Config");
    public static boolean isJumpingAllowed = true;
    public static boolean flying = true;
    public static boolean riding = false;
    public static List<String> ridingException = new ArrayList<String>();

    public static void load(MinecraftServer srv) {
        File config = new File(srv.method_3831(), "config/goprone.json");
        if (!config.exists()) {
            config.getParentFile().mkdirs();
            try (FileWriter fw = new FileWriter(config);){
                new GsonBuilder().setPrettyPrinting().excludeFieldsWithModifiers(new int[]{128}).create().toJson((Object)new Config(), (Appendable)fw);
            }
            catch (Throwable t) {
                LOG.error("Unable to save config", t);
            }
            return;
        }
        try (FileReader fr = new FileReader(config);){
            new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).create().fromJson((Reader)fr, Config.class);
        }
        catch (Throwable t) {
            LOG.error("Unable to save config", t);
        }
    }

    public static boolean test(class_1657 pe) {
        if (!flying && !pe.method_24828()) {
            return false;
        }
        if (pe.method_5765()) {
            if (riding) {
                return !ridingException.contains(class_1299.method_5890((class_1299)pe.method_5854().method_5864()).toString());
            }
            return ridingException.contains(class_1299.method_5890((class_1299)pe.method_5854().method_5864()).toString());
        }
        return true;
    }
}

