/*
 * Decompiled with CFR 0.152.
 */
package alpvax.mc.goprone;

import alpvax.mc.goprone.IForcePose;
import alpvax.mc.goprone.IProneData;
import alpvax.mc.goprone.validation.ProneCheck;
import alpvax.mc.goprone.validation.RidingCheck;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_4050;
import org.jetbrains.annotations.Nullable;

public class PlayerProneData
implements IProneData {
    private boolean shouldBeProne;
    private final Set<ProneCheck<?>> failedChecks = new HashSet();
    private boolean dirty = false;
    @Nullable
    private class_1299<?> prevRiding;

    public PlayerProneData(class_1657 player) {
        class_1297 riding = player.method_5854();
        this.prevRiding = riding == null ? null : riding.method_5864();
    }

    void markDirty() {
        this.dirty = true;
    }

    @Override
    public void setProne(boolean prone) {
        this.shouldBeProne = prone;
        this.markDirty();
    }

    @Override
    public boolean shouldBeProne() {
        return this.shouldBeProne;
    }

    private void updateRiding(@Nullable class_1299<?> riding) {
        this.prevRiding = riding;
        if (riding == null || RidingCheck.checkEntityType(riding) ? this.failedChecks.remove(RidingCheck.INSTANCE) : this.failedChecks.add(RidingCheck.INSTANCE)) {
            this.markDirty();
        }
    }

    @Override
    public void setRiding(@Nullable class_1299<?> riding) {
        if (riding != this.prevRiding) {
            this.updateRiding(riding);
        }
    }

    public void setRiding(@Nullable class_1297 riding) {
        if (riding != null) {
            class_1299 t = riding.method_5864();
            if (t != this.prevRiding) {
                this.updateRiding(t);
            }
        } else if (this.prevRiding != null) {
            this.updateRiding(null);
        }
    }

    public <T> boolean updateCheckState(class_1657 player, ProneCheck<T> check, T data) {
        return switch (check.test(player, !this.failedChecks.contains(check), data)) {
            default -> throw new IncompatibleClassChangeError();
            case ProneCheck.Result.PASSED -> this.failedChecks.remove(check);
            case ProneCheck.Result.FAILED -> this.failedChecks.add(check);
            case ProneCheck.Result.UNCHANGED -> false;
        };
    }

    @Override
    public void playerTick(class_1657 player) {
        if (TICK_CHECKS.parallelStream().map(c -> this.updateCheckState(player, (ProneCheck)c, null)).reduce((a, b) -> a != false || b != false).orElse(false).booleanValue()) {
            this.markDirty();
        }
        this.setRiding(player.method_5854());
        if (this.dirty) {
            this.updateProneState(player);
        }
    }

    protected void updateProneState(class_1657 player) {
        if (this.shouldBeProne && this.failedChecks.isEmpty()) {
            ((IForcePose)player).setForcedPose(class_4050.field_18079);
        } else {
            ((IForcePose)player).setForcedPose(null);
        }
        this.dirty = false;
    }

    @Override
    @Nullable
    public class_1299<?> getPrevRiding() {
        return this.prevRiding;
    }
}

