/*
 * Decompiled with CFR 0.152.
 */
package alpvax.mc.goprone.network;

import alpvax.mc.goprone.network.IClientHandler;
import alpvax.mc.goprone.network.IMessageType;
import alpvax.mc.goprone.network.IServerHandler;
import alpvax.mc.goprone.network.packets.ClientBoundPackets;
import alpvax.mc.goprone.network.packets.ServerBoundPackets;
import java.util.Optional;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public abstract class PacketHandler {
    private static PacketHandler instance;

    protected PacketHandler() {
        if (instance != null) {
            throw new IllegalStateException("Cannot create multiple instances of PacketHandler!");
        }
        instance = this;
    }

    public final PacketHandler register() {
        Optional.ofNullable(this.getServerHandler()).ifPresent(server -> {
            for (ServerBoundPackets pkt : ServerBoundPackets.values()) {
                server.register(pkt);
            }
        });
        Optional.ofNullable(this.getClientHandler()).ifPresent(client -> {
            for (ClientBoundPackets pkt : ClientBoundPackets.values()) {
                client.register(pkt);
            }
        });
        this.registerNonPlayEvents();
        return this;
    }

    @Nullable
    protected abstract IServerHandler<?> getServerHandler();

    @Nullable
    protected abstract IClientHandler<?> getClientHandler();

    protected void registerNonPlayEvents() {
    }

    public static <MSG extends IMessageType.IServerBoundMessage> void sendToServer(MSG msg) {
        instance.send(msg);
    }

    protected abstract <MSG extends IMessageType.IServerBoundMessage> void send(MSG var1);

    public static <MSG extends IMessageType.IClientBoundMessage> void sendTo(MSG msg, class_3222 player) {
        instance.send(msg, player);
    }

    protected abstract <MSG extends IMessageType.IClientBoundMessage> void send(MSG var1, class_3222 var2);
}

