/*
 * Decompiled with CFR 0.152.
 */
package ru.vidtu;

import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Config {
    public static final transient Logger LOG = LogManager.getLogger((String)"GoProne Config");
    public static boolean isJumpingAllowed = true;
    public static boolean flying = true;
    public static boolean riding = false;
    public static boolean climbing = false;

    public static void load(MinecraftServer srv) {
        File config = srv.method_3758("config/goprone.json");
        if (!config.exists()) {
            config.getParentFile().mkdirs();
            try (FileWriter fw = new FileWriter(config);){
                new GsonBuilder().setPrettyPrinting().excludeFieldsWithModifiers(new int[]{128}).create().toJson((Object)new Config(), (Appendable)fw);
            }
            catch (Throwable t) {
                LOG.error("Unable to save config", t);
            }
        } else {
            try (FileReader fr = new FileReader(config);){
                new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).create().fromJson((Reader)fr, Config.class);
            }
            catch (Throwable t) {
                LOG.error("Unable to save config", t);
            }
        }
    }
}

