/*
 * Decompiled with CFR 0.152.
 */
package alpvax.mc.goprone;

import alpvax.mc.goprone.config.ConfigOptions;
import alpvax.mc.goprone.platform.service.Services;
import alpvax.mc.goprone.validation.Checks;
import alpvax.mc.goprone.validation.RidingCheck;
import java.util.EnumSet;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_4050;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerProneData {
    @NotNull
    class_1657 player;
    private boolean shouldBeProne;
    private final EnumSet<Checks> failedChecks = EnumSet.noneOf(Checks.class);
    private boolean dirty = false;
    @Nullable
    private class_1299<?> prevRiding;

    public PlayerProneData(@NotNull class_1657 player) {
        this.player = player;
        class_1297 riding = player.method_5854();
        this.prevRiding = riding == null ? null : riding.method_5864();
    }

    public void markDirty() {
        this.dirty = true;
    }

    public boolean shouldBeProne() {
        return this.shouldBeProne;
    }

    public void setProne(boolean prone) {
        this.shouldBeProne = prone;
        this.updateProneState();
    }

    public void setRiding(@Nullable class_1299<?> riding) {
        this.prevRiding = riding;
        if (riding == null || RidingCheck.checkEntityType(riding) ? this.failedChecks.remove((Object)Checks.RIDING) : this.failedChecks.add(Checks.RIDING)) {
            this.markDirty();
        }
    }

    public void playerTick() {
        class_1297 riding;
        if (Checks.CLIMBING.updateFailed(this.player.method_6101(), this.failedChecks)) {
            this.markDirty();
        }
        if (Checks.FLYING.updateFailed(!this.player.method_24828(), this.failedChecks)) {
            this.markDirty();
        }
        if ((riding = this.player.method_5854()) != null) {
            class_1299 t = this.player.method_5854().method_5864();
            if (t != this.prevRiding) {
                this.setRiding(t);
            }
        } else if (this.prevRiding != null) {
            this.setRiding(null);
        }
        if (this.dirty) {
            this.updateProneState();
        }
    }

    private void updateProneState() {
        if (this.shouldBeProne && this.failedChecks.isEmpty()) {
            Services.PRONE.setForcedPose(this.player, class_4050.field_18079);
            if (!ConfigOptions.instance().sprintingAllowed.get()) {
                this.player.method_5728(false);
            }
        } else {
            Services.PRONE.setForcedPose(this.player, null);
        }
        this.dirty = false;
    }
}

