/*
 * Decompiled with CFR 0.152.
 */
package alpvax.mc.goprone.network;

import alpvax.mc.goprone.network.IClientHandler;
import alpvax.mc.goprone.network.IServerHandler;
import alpvax.mc.goprone.network.PacketHandler;
import java.util.function.Function;
import net.minecraft.class_2540;
import net.minecraft.class_3222;
import org.apache.logging.log4j.util.BiConsumer;
import org.apache.logging.log4j.util.TriConsumer;

public interface IMessageType<T> {
    public void encode(T var1, class_2540 var2);

    public T decode(class_2540 var1);

    public void handleServerSide(IServerHandler<?> var1, T var2, IServerHandler.IContext var3);

    public void handleClientSide(IClientHandler<?> var1, T var2, IClientHandler.IContext var3);

    public static <MSG extends IServerBoundMessage> IMessageType<MSG> serverBound(final BiConsumer<MSG, class_2540> encode, final Function<class_2540, MSG> decode, final TriConsumer<IServerHandler<?>, MSG, IServerHandler.IContext> handler) {
        return new IMessageType<MSG>(){

            @Override
            public void encode(MSG msg, class_2540 buf) {
                encode.accept(msg, (Object)buf);
            }

            @Override
            public MSG decode(class_2540 buf) {
                return (IServerBoundMessage)decode.apply(buf);
            }

            @Override
            public void handleServerSide(IServerHandler<?> serverHandler, MSG msg, IServerHandler.IContext ctx) {
                handler.accept(serverHandler, msg, (Object)ctx);
            }

            @Override
            public void handleClientSide(IClientHandler<?> clientHandler, MSG msg, IClientHandler.IContext ctx) {
                throw new IllegalStateException("Attempting to handle a server bound packet on the client (%s)".formatted(msg.getClass().getSimpleName()));
            }
        };
    }

    public static <MSG extends IClientBoundMessage> IMessageType<MSG> clientBound(final BiConsumer<MSG, class_2540> encode, final Function<class_2540, MSG> decode, final TriConsumer<IClientHandler<?>, MSG, IClientHandler.IContext> handler) {
        return new IMessageType<MSG>(){

            @Override
            public void encode(MSG msg, class_2540 buf) {
                encode.accept(msg, (Object)buf);
            }

            @Override
            public MSG decode(class_2540 buf) {
                return (IClientBoundMessage)decode.apply(buf);
            }

            @Override
            public void handleServerSide(IServerHandler<?> serverHandler, MSG msg, IServerHandler.IContext ctx) {
                throw new IllegalStateException("Attempting to handle a client bound packet on the server (%s)".formatted(msg.getClass().getSimpleName()));
            }

            @Override
            public void handleClientSide(IClientHandler<?> clientHandler, MSG msg, IClientHandler.IContext ctx) {
                handler.accept(clientHandler, msg, (Object)ctx);
            }
        };
    }

    public static interface IClientBoundMessage {
        default public void sendToClient(class_3222 target) {
            PacketHandler.sendTo(this, target);
        }
    }

    public static interface IServerBoundMessage {
        default public void sendToServer() {
            PacketHandler.sendToServer(this);
        }
    }
}

