/*
 * Decompiled with CFR 0.152.
 */
package alpvax.mc.goprone.forge;

import alpvax.mc.goprone.PlayerProneData;
import alpvax.mc.goprone.config.ConfigOptions;
import alpvax.mc.goprone.forge.ClientProxy;
import alpvax.mc.goprone.forge.ProneDataCapabilityProvider;
import alpvax.mc.goprone.forge.datagen.TagsProvider;
import alpvax.mc.goprone.forge.network.ForgePacketHandler;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod(value="goprone")
public class GoProne {
    public GoProne() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        ForgePacketHandler.initAndRegister();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ConfigOptions.SPEC);
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> modBus.addListener(ClientProxy::init));
        modBus.addListener(this::onModConfigEvent);
        modBus.addListener(this::registerCapability);
        modBus.addListener(this::gatherData);
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "ANY", (remote, isServer) -> true));
    }

    private void onModConfigEvent(ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == ConfigOptions.SPEC) {
            ConfigOptions.instance().bakeConfig();
            if (configEvent instanceof ModConfigEvent.Reloading) {
                DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientProxy::onConfigChange);
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                if (server != null) {
                    server.m_6846_().m_11314_().forEach(p -> p.getCapability(ProneDataCapabilityProvider.CAPABILITY).ifPresent(PlayerProneData::markDirty));
                }
            }
        }
    }

    private void registerCapability(RegisterCapabilitiesEvent event) {
        event.register(PlayerProneData.class);
    }

    @SubscribeEvent
    public void attachPlayerCapability(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)object;
            event.addCapability(new ResourceLocation("goprone", "player_cap"), (ICapabilityProvider)new ProneDataCapabilityProvider((Player)player));
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            event.player.getCapability(ProneDataCapabilityProvider.CAPABILITY).ifPresent(PlayerProneData::playerTick);
            this.onPlayerSprint(event.player);
        }
    }

    public void onPlayerSprint(Player player) {
        if (player.getForcedPose() == Pose.SWIMMING && !ConfigOptions.instance().sprintingAllowed.get()) {
            player.m_6858_(false);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerJump(LivingEvent.LivingJumpEvent event) {
        Player player;
        Boolean disabled;
        if (event.getEntity().m_9236_().f_46443_ && (disabled = (Boolean)DistExecutor.unsafeCallWhenOn((Dist)Dist.CLIENT, () -> ClientProxy::isDisabled)) != null && disabled.booleanValue()) {
            return;
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_20096_() && player.m_20089_() == Pose.SWIMMING && !ConfigOptions.instance().jumpingAllowed.get()) {
            Vec3 motion = player.m_20184_();
            player.m_20334_(motion.f_82479_, 0.0, motion.f_82481_);
        }
    }

    private void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        PackOutput packOutput = gen.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        gen.addProvider(event.includeServer(), (DataProvider)new TagsProvider(packOutput, lookupProvider, event.getExistingFileHelper()));
    }
}

