/*
 * Decompiled with CFR 0.152.
 */
package dev.mrsterner.guardvillagers;

import dev.mrsterner.guardvillagers.GuardVillagersConfig;
import dev.mrsterner.guardvillagers.client.screen.GuardVillagerScreenHandler;
import dev.mrsterner.guardvillagers.common.entity.GuardEntity;
import java.util.function.Predicate;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricEntityTypeBuilder;
import net.fabricmc.fabric.api.screenhandler.v1.ScreenHandlerRegistry;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1764;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1829;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3852;
import net.minecraft.class_3917;
import net.minecraft.class_4048;
import net.minecraft.class_4140;
import net.minecraft.class_5132;

public class GuardVillagers
implements ModInitializer {
    public static final String MODID = "guardvillagers";
    public static GuardVillagersConfig config;
    public static final class_3917<GuardVillagerScreenHandler> GUARD_SCREEN_HANDLER;
    public static final class_1299<GuardEntity> GUARD_VILLAGER;
    public static final class_1792 GUARD_SPAWN_EGG;

    public void onInitialize() {
        AutoConfig.register(GuardVillagersConfig.class, GsonConfigSerializer::new);
        config = (GuardVillagersConfig)AutoConfig.getConfigHolder(GuardVillagersConfig.class).getConfig();
        FabricDefaultAttributeRegistry.register(GUARD_VILLAGER, (class_5132.class_5133)GuardEntity.createAttributes());
        class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)new class_2960(MODID, "guard_spawn_egg"), (Object)GUARD_SPAWN_EGG);
        UseEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            class_1646 villagerEntity;
            class_1297 target;
            class_1799 itemStack = player.method_5998(hand);
            if ((itemStack.method_7909() instanceof class_1829 || itemStack.method_7909() instanceof class_1764) && player.method_5715() && hitResult != null && (target = hitResult.method_17782()) instanceof class_1646 && !(villagerEntity = (class_1646)target).method_6109() && (villagerEntity.method_7231().method_16924() == class_3852.field_17051 || villagerEntity.method_7231().method_16924() == class_3852.field_17062) && (!GuardVillagers.config.general.ConvertVillagerIfHaveHOTV || player.method_6059(class_1294.field_18980) && GuardVillagers.config.general.ConvertVillagerIfHaveHOTV)) {
                GuardVillagers.convertVillager(villagerEntity, player, world);
                if (!player.method_31549().field_7477) {
                    itemStack.method_7934(1);
                }
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        });
    }

    public static boolean hotvChecker(class_1657 player) {
        return player.method_6059(class_1294.field_18980) || !GuardVillagers.config.general.giveGuardStuffHOTV;
    }

    public static class_1268 getHandWith(class_1309 livingEntity, Predicate<class_1792> itemPredicate) {
        return itemPredicate.test(livingEntity.method_6047().method_7909()) ? class_1268.field_5808 : class_1268.field_5810;
    }

    private static void convertVillager(class_1646 villagerEntity, class_1657 player, class_1937 world) {
        player.method_6104(class_1268.field_5808);
        class_1799 itemstack = player.method_6118(class_1304.field_6173);
        GuardEntity guard = (GuardEntity)GUARD_VILLAGER.method_5883(world);
        if (guard == null) {
            return;
        }
        if (player.field_6002.method_8608()) {
            class_2400 particleEffect = class_2398.field_11211;
            for (int i = 0; i < 10; ++i) {
                double d0 = villagerEntity.method_6051().nextGaussian() * 0.02;
                double d1 = villagerEntity.method_6051().nextGaussian() * 0.02;
                double d2 = villagerEntity.method_6051().nextGaussian() * 0.02;
                villagerEntity.field_6002.method_8406((class_2394)particleEffect, villagerEntity.method_23317() + (double)(villagerEntity.method_6051().nextFloat() * villagerEntity.method_17681() * 2.0f) - (double)villagerEntity.method_17681(), villagerEntity.method_23318() + 0.5 + (double)(villagerEntity.method_6051().nextFloat() * villagerEntity.method_17681()), villagerEntity.method_23321() + (double)(villagerEntity.method_6051().nextFloat() * villagerEntity.method_17681() * 2.0f) - (double)villagerEntity.method_17681(), d0, d1, d2);
            }
        }
        guard.method_5719((class_1297)villagerEntity);
        guard.field_6225 = villagerEntity.field_6225;
        guard.field_6211 = villagerEntity.field_6211;
        guard.field_6241 = villagerEntity.field_6241;
        guard.method_5808(villagerEntity.method_23317(), villagerEntity.method_23318(), villagerEntity.method_23321(), villagerEntity.method_36454(), villagerEntity.method_36455());
        guard.method_5783(class_3417.field_14815, 1.0f, 1.0f);
        guard.method_5673(class_1304.field_6173, itemstack.method_7972());
        guard.guardInventory.method_5447(5, itemstack.method_7972());
        int i = GuardEntity.getRandomTypeForBiome((class_1936)guard.field_6002, guard.method_24515());
        guard.setGuardVariant(i);
        guard.method_5971();
        guard.method_5665(villagerEntity.method_5797());
        guard.method_5880(villagerEntity.method_5807());
        guard.method_5946(class_1304.field_6169, 100.0f);
        guard.method_5946(class_1304.field_6174, 100.0f);
        guard.method_5946(class_1304.field_6166, 100.0f);
        guard.method_5946(class_1304.field_6172, 100.0f);
        guard.method_5946(class_1304.field_6173, 100.0f);
        guard.method_5946(class_1304.field_6171, 100.0f);
        world.method_8649((class_1297)guard);
        villagerEntity.method_19176(class_4140.field_18438);
        villagerEntity.method_19176(class_4140.field_18439);
        villagerEntity.method_19176(class_4140.field_18440);
        villagerEntity.method_31472();
    }

    static {
        GUARD_SCREEN_HANDLER = ScreenHandlerRegistry.registerExtended((class_2960)new class_2960(MODID, "guard_screen"), GuardVillagerScreenHandler::new);
        GUARD_VILLAGER = (class_1299)class_2378.method_10230((class_2378)class_2378.field_11145, (class_2960)new class_2960(MODID, "guard"), (Object)FabricEntityTypeBuilder.create((class_1311)class_1311.field_6294, GuardEntity::new).dimensions(class_4048.method_18385((float)0.6f, (float)1.8f)).build());
        GUARD_SPAWN_EGG = new class_1826(GUARD_VILLAGER, 5651507, 8412749, (class_1792.class_1793)new FabricItemSettings().group(class_1761.field_7932));
    }
}

