/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import tallestegg.guardvillagers.GuardPacketHandler;
import tallestegg.guardvillagers.configuration.GuardConfig;
import tallestegg.guardvillagers.entities.Guard;
import tallestegg.guardvillagers.entities.GuardContainer;
import tallestegg.guardvillagers.networking.GuardFollowPacket;
import tallestegg.guardvillagers.networking.GuardSetPatrolPosPacket;

public class GuardInventoryScreen
extends AbstractContainerScreen<GuardContainer> {
    private static final ResourceLocation GUARD_GUI_TEXTURES = new ResourceLocation("guardvillagers", "textures/container/inventory.png");
    private static final ResourceLocation GUARD_FOLLOWING_ICON = new ResourceLocation("guardvillagers", "textures/container/following_icons.png");
    private static final ResourceLocation GUARD_NOT_FOLLOWING_ICON = new ResourceLocation("guardvillagers", "textures/container/not_following_icons.png");
    private static final ResourceLocation PATROL_ICON = new ResourceLocation("guardvillagers", "textures/container/patrollingui.png");
    private static final ResourceLocation NOT_PATROLLING_ICON = new ResourceLocation("guardvillagers", "textures/container/notpatrollingui.png");
    private final Guard guard;
    private Player player;
    private float mousePosX;
    private float mousePosY;
    private boolean buttonPressed;

    public GuardInventoryScreen(GuardContainer container, Inventory playerInventory, Guard guard) {
        super((AbstractContainerMenu)container, playerInventory, guard.m_5446_());
        this.guard = guard;
        this.f_97728_ = 80;
        this.f_97730_ = 100;
        this.f_96546_ = false;
        this.player = playerInventory.f_35978_;
    }

    public void m_7856_() {
        super.m_7856_();
        if (GuardConfig.followHero && this.player.m_21023_(MobEffects.f_19595_) || !GuardConfig.followHero) {
            this.m_142416_((GuiEventListener)new GuardGuiButton(this.f_97735_ + 100, this.f_96544_ / 2 - 40, 20, 18, 0, 0, 19, GUARD_FOLLOWING_ICON, GUARD_NOT_FOLLOWING_ICON, true, p_214086_1_ -> GuardPacketHandler.INSTANCE.sendToServer((Object)new GuardFollowPacket(this.guard.m_19879_()))));
        }
        if (GuardConfig.setGuardPatrolHotv && this.player.m_21023_(MobEffects.f_19595_) || !GuardConfig.setGuardPatrolHotv) {
            this.m_142416_((GuiEventListener)new GuardGuiButton(this.f_97735_ + 120, this.f_96544_ / 2 - 40, 20, 18, 0, 0, 19, PATROL_ICON, NOT_PATROLLING_ICON, false, p_214086_1_ -> {
                this.buttonPressed = !this.buttonPressed;
                GuardPacketHandler.INSTANCE.sendToServer((Object)new GuardSetPatrolPosPacket(this.guard.m_19879_(), this.buttonPressed));
            }));
        }
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int x, int y) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUARD_GUI_TEXTURES);
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        GuardInventoryScreen.m_93228_((PoseStack)matrixStack, (int)i, (int)j, (int)0, (int)0, (int)this.f_97726_, (int)this.f_97727_);
        InventoryScreen.m_274545_((PoseStack)matrixStack, (int)(i + 51), (int)(j + 75), (int)30, (float)((float)(i + 51) - this.mousePosX), (float)((float)(j + 75 - 50) - this.mousePosY), (LivingEntity)this.guard);
    }

    protected void m_7027_(PoseStack matrixStack, int x, int y) {
        super.m_7027_(matrixStack, x, y);
        int health = Mth.m_14167_((float)this.guard.m_21223_());
        int armor = this.guard.m_21230_();
        MutableComponent guardHealthText = Component.m_237110_((String)"guardinventory.health", (Object[])new Object[]{health});
        MutableComponent guardArmorText = Component.m_237110_((String)"guardinventory.armor", (Object[])new Object[]{armor});
        this.f_96547_.m_92889_(matrixStack, (Component)guardHealthText, 80.0f, 20.0f, 0x404040);
        this.f_96547_.m_92889_(matrixStack, (Component)guardArmorText, 80.0f, 30.0f, 0x404040);
    }

    public void m_86412_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        this.mousePosX = mouseX;
        this.mousePosY = mouseY;
        super.m_86412_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
    }

    class GuardGuiButton
    extends ImageButton {
        private ResourceLocation texture;
        private ResourceLocation newTexture;
        private boolean isFollowButton;

        public GuardGuiButton(int xIn, int yIn, int widthIn, int heightIn, int xTexStartIn, int yTexStartIn, int yDiffTextIn, ResourceLocation resourceLocationIn, ResourceLocation newTexture, boolean isFollowButton, Button.OnPress onPressIn) {
            super(xIn, yIn, widthIn, heightIn, xTexStartIn, yTexStartIn, yDiffTextIn, resourceLocationIn, onPressIn);
            this.texture = resourceLocationIn;
            this.newTexture = newTexture;
            this.isFollowButton = isFollowButton;
        }

        public boolean requirementsForTexture() {
            boolean following = GuardInventoryScreen.this.guard.isFollowing();
            boolean patrol = GuardInventoryScreen.this.guard.isPatrolling();
            return this.isFollowButton ? following : patrol;
        }

        public void m_87963_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            ResourceLocation icon = this.requirementsForTexture() ? this.texture : this.newTexture;
            RenderSystem.m_157456_((int)0, (ResourceLocation)icon);
            int i = this.f_94225_;
            if (this.m_198029_()) {
                i += this.f_94226_;
            }
            RenderSystem.m_69482_();
            GuardGuiButton.m_93133_((PoseStack)matrixStack, (int)this.m_252754_(), (int)this.m_252907_(), (float)this.f_94224_, (float)i, (int)this.f_93618_, (int)this.f_93619_, (int)this.f_94227_, (int)this.f_94228_);
        }
    }
}

