/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.entities.ai.goals;

import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import tallestegg.guardvillagers.GuardEntityType;
import tallestegg.guardvillagers.configuration.GuardConfig;
import tallestegg.guardvillagers.entities.Guard;

public class RangedCrossbowAttackPassiveGoal<T extends PathfinderMob & CrossbowAttackMob>
extends Goal {
    public static final UniformInt PATHFINDING_DELAY_RANGE = TimeUtil.m_145020_((int)1, (int)2);
    private final T mob;
    private final double speedModifier;
    private final float attackRadiusSqr;
    protected double wantedX;
    protected double wantedY;
    protected double wantedZ;
    private CrossbowState crossbowState = CrossbowState.UNCHARGED;
    private int seeTime;
    private int attackDelay;
    private int updatePathDelay;
    private int runTime;

    public RangedCrossbowAttackPassiveGoal(T pMob, double pSpeedModifier, float pAttackRadius) {
        this.mob = pMob;
        this.speedModifier = pSpeedModifier;
        this.attackRadiusSqr = pAttackRadius * pAttackRadius;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.isValidTarget() && this.isHoldingCrossbow();
    }

    private boolean isHoldingCrossbow() {
        return this.mob.m_21093_(is -> is.m_41720_() instanceof CrossbowItem);
    }

    public boolean m_8045_() {
        return this.isValidTarget() && (this.m_8036_() || !this.mob.m_21573_().m_26571_()) && this.isHoldingCrossbow();
    }

    private boolean isValidTarget() {
        return this.mob.m_5448_() != null && this.mob.m_5448_().m_6084_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.mob.m_21561_(false);
        this.mob.m_6710_(null);
        this.seeTime = 0;
        if (this.mob.m_6117_()) {
            this.mob.m_5810_();
            ((CrossbowAttackMob)this.mob).m_6136_(false);
        }
        this.mob.m_20124_(Pose.STANDING);
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8056_() {
        this.mob.m_21561_(true);
    }

    public void m_8037_() {
        LivingEntity livingentity = this.mob.m_5448_();
        if (livingentity != null) {
            boolean canSee2;
            boolean hasSeenEntityRecently;
            boolean canSee = this.mob.m_21574_().m_148306_((Entity)livingentity);
            boolean bl = hasSeenEntityRecently = this.seeTime > 0;
            if (canSee != hasSeenEntityRecently) {
                this.seeTime = 0;
            }
            this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
            double d0 = this.mob.m_20280_((Entity)livingentity);
            double d1 = livingentity.m_20270_(this.mob);
            if (d1 <= 4.0) {
                this.mob.m_21566_().m_24988_(this.mob.m_6117_() ? -0.5f : -3.0f, 0.0f);
                this.mob.m_21391_((Entity)livingentity, 30.0f, 30.0f);
            }
            if (this.mob.m_217043_().m_188503_(50) == 0) {
                if (this.mob.m_217003_(Pose.STANDING)) {
                    this.mob.m_20124_(Pose.CROUCHING);
                } else {
                    this.mob.m_20124_(Pose.STANDING);
                }
            }
            boolean bl2 = canSee2 = (d0 > (double)this.attackRadiusSqr || this.seeTime < 5) && this.attackDelay == 0;
            if (canSee2) {
                --this.updatePathDelay;
                if (this.updatePathDelay <= 0 && !((Guard)((Object)this.mob)).isPatrolling()) {
                    this.mob.m_21573_().m_5624_((Entity)livingentity, this.canRun() ? this.speedModifier : this.speedModifier * 0.5);
                    this.updatePathDelay = PATHFINDING_DELAY_RANGE.m_214085_(this.mob.m_217043_());
                }
            } else {
                this.updatePathDelay = 0;
                this.mob.m_21573_().m_26573_();
            }
            this.mob.m_21391_((Entity)livingentity, 30.0f, 30.0f);
            this.mob.m_21563_().m_24960_((Entity)livingentity, 30.0f, 30.0f);
            if (this.friendlyInLineOfSight() && GuardConfig.FriendlyFire) {
                this.crossbowState = CrossbowState.FIND_NEW_POSITION;
            }
            if (this.crossbowState == CrossbowState.FIND_NEW_POSITION && GuardConfig.FriendlyFire) {
                this.mob.m_5810_();
                ((CrossbowAttackMob)this.mob).m_6136_(false);
                if (this.findPosition()) {
                    this.mob.m_21573_().m_26519_(this.wantedX, this.wantedY, this.wantedZ, this.mob.m_6047_() ? 0.5 : 1.2);
                }
                this.crossbowState = CrossbowState.UNCHARGED;
            } else if (this.crossbowState == CrossbowState.UNCHARGED) {
                if (hasSeenEntityRecently) {
                    this.mob.m_6672_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof CrossbowItem));
                    this.crossbowState = CrossbowState.CHARGING;
                    ((CrossbowAttackMob)this.mob).m_6136_(true);
                }
            } else if (this.crossbowState == CrossbowState.CHARGING) {
                ItemStack itemstack;
                int i;
                if (!this.mob.m_6117_()) {
                    this.crossbowState = CrossbowState.UNCHARGED;
                }
                if ((i = this.mob.m_21252_()) >= CrossbowItem.m_40939_((ItemStack)(itemstack = this.mob.m_21211_())) || CrossbowItem.m_40932_((ItemStack)itemstack)) {
                    this.mob.m_21253_();
                    this.crossbowState = CrossbowState.CHARGED;
                    this.attackDelay = 10 + this.mob.m_217043_().m_188503_(5);
                    ((CrossbowAttackMob)this.mob).m_6136_(false);
                }
            } else if (this.crossbowState == CrossbowState.CHARGED) {
                --this.attackDelay;
                if (this.attackDelay == 0) {
                    this.crossbowState = CrossbowState.READY_TO_ATTACK;
                }
            } else if (this.crossbowState == CrossbowState.READY_TO_ATTACK && canSee) {
                ((RangedAttackMob)this.mob).m_6504_(livingentity, 1.0f);
                ItemStack itemstack1 = this.mob.m_21120_(ProjectileUtil.getWeaponHoldingHand(this.mob, item -> item instanceof CrossbowItem));
                CrossbowItem.m_40884_((ItemStack)itemstack1, (boolean)false);
                this.crossbowState = CrossbowState.UNCHARGED;
            }
        }
    }

    private boolean friendlyInLineOfSight() {
        List list = ((PathfinderMob)this.mob).f_19853_.m_45933_(this.mob, this.mob.m_20191_().m_82400_(5.0));
        for (Entity guard : list) {
            boolean isVillager;
            if (guard == this.mob.m_5448_() || !(isVillager = ((Guard)((Object)this.mob)).getOwner() == guard || guard.m_6095_() == EntityType.f_20492_ || guard.m_6095_() == GuardEntityType.GUARD.get() || guard.m_6095_() == EntityType.f_20460_)) continue;
            Vec3 vector3d = this.mob.m_20154_();
            Vec3 vector3d1 = guard.m_20182_().m_82505_(this.mob.m_20182_()).m_82541_();
            vector3d1 = new Vec3(vector3d1.f_82479_, vector3d1.f_82480_, vector3d1.f_82481_);
            if (!(vector3d1.m_82526_(vector3d) < 1.0) || !this.mob.m_142582_(guard) || !((double)guard.m_20270_(this.mob) <= 4.0)) continue;
            return true;
        }
        return false;
    }

    public boolean findPosition() {
        Vec3 vector3d = this.getPosition();
        if (vector3d == null) {
            return false;
        }
        this.wantedX = vector3d.f_82479_;
        this.wantedY = vector3d.f_82480_;
        this.wantedZ = vector3d.f_82481_;
        return true;
    }

    @Nullable
    protected Vec3 getPosition() {
        if (this.isValidTarget()) {
            return DefaultRandomPos.m_148407_(this.mob, (int)16, (int)7, (Vec3)this.mob.m_5448_().m_20182_());
        }
        return DefaultRandomPos.m_148403_(this.mob, (int)16, (int)7);
    }

    private boolean canRun() {
        return this.crossbowState == CrossbowState.UNCHARGED;
    }

    public static enum CrossbowState {
        UNCHARGED,
        CHARGING,
        CHARGED,
        READY_TO_ATTACK,
        FIND_NEW_POSITION;

    }
}

