/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingChangeTargetEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.living.LivingHurtEvent;
import tallestegg.guardvillagers.GuardEntityType;
import tallestegg.guardvillagers.configuration.GuardConfig;
import tallestegg.guardvillagers.entities.Guard;
import tallestegg.guardvillagers.entities.ai.goals.AttackEntityDaytimeGoal;
import tallestegg.guardvillagers.entities.ai.goals.HealGolemGoal;
import tallestegg.guardvillagers.entities.ai.goals.HealGuardAndPlayerGoal;

@Mod.EventBusSubscriber(modid="guardvillagers")
public class HandlerEvents {
    @SubscribeEvent
    public static void onEntityTarget(LivingChangeTargetEvent event) {
        boolean isVillager;
        LivingEntity entity = event.getEntity();
        LivingEntity target = event.getNewTarget();
        if (target == null || entity.getType() == GuardEntityType.GUARD.get()) {
            return;
        }
        boolean bl = isVillager = target.getType() == EntityType.VILLAGER || target.getType() == GuardEntityType.GUARD.get();
        if (isVillager) {
            List list = entity.level().getEntitiesOfClass(Mob.class, entity.getBoundingBox().inflate(GuardConfig.GuardVillagerHelpRange, 5.0, GuardConfig.GuardVillagerHelpRange));
            for (Mob mob : list) {
                if (mob.getTarget() != null || mob.getType() != GuardEntityType.GUARD.get() && mob.getType() != EntityType.IRON_GOLEM) continue;
                if (mob.getTeam() != null && entity.getTeam() != null && entity.getTeam().isAlliedTo(mob.getTeam())) {
                    return;
                }
                mob.setTarget(entity);
            }
        }
        if (entity instanceof IronGolem) {
            IronGolem golem = (IronGolem)entity;
            if (target instanceof Guard) {
                golem.setTarget(null);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        boolean isGolem;
        LivingEntity entity = event.getEntity();
        Entity trueSource = event.getSource().getEntity();
        if (entity == null || trueSource == null) {
            return;
        }
        boolean isVillager = entity.getType() == EntityType.VILLAGER || entity.getType() == GuardEntityType.GUARD.get();
        boolean bl = isGolem = isVillager || entity.getType() == EntityType.IRON_GOLEM;
        if (isGolem && trueSource.getType() == GuardEntityType.GUARD.get() && !GuardConfig.guardArrowsHurtVillagers) {
            event.setAmount(0.0f);
            event.setCanceled(true);
        }
        if (isVillager && event.getSource().getEntity() instanceof Mob) {
            List list = trueSource.level().getEntitiesOfClass(Mob.class, trueSource.getBoundingBox().inflate(GuardConfig.GuardVillagerHelpRange, 5.0, GuardConfig.GuardVillagerHelpRange));
            for (Mob mob : list) {
                boolean type = mob.getType() == GuardEntityType.GUARD.get() || mob.getType() == EntityType.IRON_GOLEM;
                boolean trueSourceGolem = trueSource.getType() == GuardEntityType.GUARD.get() || trueSource.getType() == EntityType.IRON_GOLEM;
                if (trueSourceGolem || !type || mob.getTarget() != null) continue;
                if (mob.getTeam() != null && entity.getTeam() != null && entity.getTeam().isAlliedTo(mob.getTeam())) {
                    return;
                }
                mob.setTarget((LivingEntity)((Mob)event.getSource().getEntity()));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof AbstractHorse) {
            AbstractHorse horse = (AbstractHorse)livingEntity;
            Vec3 vec3 = new Vec3((double)horse.xxa, (double)horse.yya, (double)horse.zza);
            if (horse.hasControllingPassenger() && horse.getControllingPassenger() instanceof Guard) {
                horse.setSpeed((float)horse.getAttributeValue(Attributes.MOVEMENT_SPEED));
                horse.travel(vec3);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingSpawned(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (mob instanceof Raider && ((Raider)mob).hasActiveRaid() && GuardConfig.RaidAnimals) {
                mob.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)((Raider)mob), Animal.class, false));
            }
            if (GuardConfig.AttackAllMobs) {
                if (mob instanceof Enemy && !GuardConfig.MobBlackList.contains(mob.getEncodeId()) && !(mob instanceof Spider)) {
                    mob.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal(mob, Guard.class, false));
                }
                if (mob instanceof Enemy && !GuardConfig.MobBlackList.contains(mob.getEncodeId()) && mob instanceof Spider) {
                    Spider spider = (Spider)mob;
                    spider.targetSelector.addGoal(3, new AttackEntityDaytimeGoal<Guard>(spider, Guard.class));
                }
            }
            if (mob instanceof AbstractIllager) {
                AbstractIllager illager = (AbstractIllager)mob;
                if (GuardConfig.IllagersRunFromPolarBears) {
                    illager.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)illager, PolarBear.class, 6.0f, 1.0, 1.2));
                }
                illager.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)illager, Guard.class, false));
            }
            if (mob instanceof AbstractVillager) {
                AbstractVillager abstractvillager = (AbstractVillager)mob;
                if (GuardConfig.VillagersRunFromPolarBears) {
                    abstractvillager.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)abstractvillager, PolarBear.class, 6.0f, 1.0, 1.2));
                }
                if (GuardConfig.WitchesVillager) {
                    abstractvillager.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)abstractvillager, Witch.class, 6.0f, 1.0, 1.2));
                }
            }
            if (mob instanceof Villager) {
                Villager villager = (Villager)mob;
                if (GuardConfig.BlackSmithHealing) {
                    villager.goalSelector.addGoal(1, (Goal)new HealGolemGoal((Mob)villager));
                }
                if (GuardConfig.ClericHealing) {
                    villager.goalSelector.addGoal(1, (Goal)new HealGuardAndPlayerGoal((Mob)villager, 1.0, 100, 0, 10.0f));
                }
            }
            if (mob instanceof IronGolem) {
                IronGolem golem = (IronGolem)mob;
                HurtByTargetGoal tolerateFriendlyFire = new HurtByTargetGoal((PathfinderMob)golem, new Class[]{Guard.class}).setAlertOthers(new Class[0]);
                golem.targetSelector.getAvailableGoals().stream().map(it -> it.getGoal()).filter(it -> it instanceof HurtByTargetGoal).findFirst().ifPresent(angerGoal -> {
                    golem.targetSelector.removeGoal(angerGoal);
                    golem.targetSelector.addGoal(2, (Goal)tolerateFriendlyFire);
                });
            }
            if (mob instanceof Zombie) {
                Zombie zombie = (Zombie)mob;
                zombie.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)zombie, Guard.class, false));
            }
            if (mob instanceof Ravager) {
                Ravager ravager = (Ravager)mob;
                ravager.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)ravager, Guard.class, false));
            }
            if (mob instanceof Witch) {
                Witch witch = (Witch)mob;
                if (GuardConfig.WitchesVillager) {
                    witch.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)witch, AbstractVillager.class, true));
                    witch.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)witch, IronGolem.class, true));
                    witch.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)witch, Guard.class, false));
                }
            }
            if (mob instanceof Cat) {
                Cat cat = (Cat)mob;
                cat.goalSelector.addGoal(1, (Goal)new AvoidEntityGoal((PathfinderMob)cat, AbstractIllager.class, 12.0f, 1.0, 1.2));
            }
        }
    }
}

