/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import tallestegg.guardvillagers.GuardEntityType;
import tallestegg.guardvillagers.configuration.GuardConfig;
import tallestegg.guardvillagers.entities.Guard;

@Mod.EventBusSubscriber(modid="guardvillagers")
public class VillagerToGuard {
    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Villager villager;
        Player player = event.getEntity();
        ItemStack itemstack = event.getEntity().getMainHandItem();
        Entity target = event.getTarget();
        if ((itemstack.getItem() instanceof SwordItem || itemstack.getItem() instanceof CrossbowItem) && player.isCrouching() && target instanceof Villager && !(villager = (Villager)target).isBaby() && (villager.getVillagerData().getProfession() == VillagerProfession.NONE || villager.getVillagerData().getProfession() == VillagerProfession.NITWIT) && (!GuardConfig.ConvertVillagerIfHaveHOTV || player.hasEffect(MobEffects.HERO_OF_THE_VILLAGE) && GuardConfig.ConvertVillagerIfHaveHOTV)) {
            VillagerToGuard.convertVillager((LivingEntity)villager, player);
            if (!player.getAbilities().instabuild) {
                itemstack.shrink(1);
            }
        }
    }

    private static void convertVillager(LivingEntity entity, Player player) {
        player.swing(InteractionHand.MAIN_HAND);
        ItemStack itemstack = player.getItemBySlot(EquipmentSlot.MAINHAND);
        Guard guard = (Guard)((EntityType)GuardEntityType.GUARD.get()).create(entity.level());
        Villager villager = (Villager)entity;
        if (guard == null) {
            return;
        }
        if (entity.level().isClientSide) {
            SimpleParticleType iparticledata = ParticleTypes.HAPPY_VILLAGER;
            for (int i = 0; i < 10; ++i) {
                double d0 = villager.getRandom().nextGaussian() * 0.02;
                double d1 = villager.getRandom().nextGaussian() * 0.02;
                double d2 = villager.getRandom().nextGaussian() * 0.02;
                villager.level().addParticle((ParticleOptions)iparticledata, villager.getX() + (double)(villager.getRandom().nextFloat() * villager.getBbWidth() * 2.0f) - (double)villager.getBbWidth(), villager.getY() + 0.5 + (double)(villager.getRandom().nextFloat() * villager.getBbHeight()), villager.getZ() + (double)(villager.getRandom().nextFloat() * villager.getBbWidth() * 2.0f) - (double)villager.getBbWidth(), d0, d1, d2);
            }
        }
        guard.copyPosition((Entity)villager);
        guard.playSound(SoundEvents.VILLAGER_YES, 1.0f, 1.0f);
        guard.setItemSlot(EquipmentSlot.MAINHAND, itemstack.copy());
        int i = Guard.getRandomTypeForBiome((LevelAccessor)guard.level(), guard.blockPosition());
        guard.setGuardVariant(i);
        guard.setPersistenceRequired();
        guard.setCustomName(villager.getCustomName());
        guard.setCustomNameVisible(villager.isCustomNameVisible());
        guard.setDropChance(EquipmentSlot.HEAD, 100.0f);
        guard.setDropChance(EquipmentSlot.CHEST, 100.0f);
        guard.setDropChance(EquipmentSlot.FEET, 100.0f);
        guard.setDropChance(EquipmentSlot.LEGS, 100.0f);
        guard.setDropChance(EquipmentSlot.MAINHAND, 100.0f);
        guard.setDropChance(EquipmentSlot.OFFHAND, 100.0f);
        guard.getGossips().add(player.getUUID(), GossipType.MINOR_POSITIVE, GuardConfig.reputationRequirement);
        villager.level().addFreshEntity((Entity)guard);
        villager.releasePoi(MemoryModuleType.HOME);
        villager.releasePoi(MemoryModuleType.JOB_SITE);
        villager.releasePoi(MemoryModuleType.MEETING_POINT);
        villager.discard();
    }
}

