/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.client.models;

import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;
import tallestegg.guardvillagers.entities.Guard;

public class GuardModel
extends HumanoidModel<Guard> {
    public ModelPart Nose;
    public ModelPart quiver;
    public ModelPart ArmLShoulderPad;
    public ModelPart ArmRShoulderPad;

    public GuardModel(ModelPart part) {
        super(part);
        this.Nose = this.head.getChild("nose");
        this.quiver = this.body.getChild("quiver");
        this.ArmLShoulderPad = this.rightArm.getChild("shoulderPad_left");
        this.ArmRShoulderPad = this.leftArm.getChild("shoulderPad_right");
        this.setRotateAngle(this.quiver, 0.0f, 0.0f, 0.2617994f);
        this.setRotateAngle(this.ArmLShoulderPad, 0.0f, 0.0f, -0.34906584f);
        this.setRotateAngle(this.ArmRShoulderPad, 0.0f, 0.0f, 0.34906584f);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = HumanoidModel.createMesh((CubeDeformation)CubeDeformation.NONE, (float)0.0f);
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition torso = partdefinition.addOrReplaceChild("body", CubeListBuilder.create().texOffs(52, 50).addBox(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = partdefinition.addOrReplaceChild("head", CubeListBuilder.create().texOffs(49, 99).addBox(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)0.0f));
        PartDefinition rightArm = partdefinition.addOrReplaceChild("right_arm", CubeListBuilder.create().texOffs(32, 75).mirror().addBox(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition leftArm = partdefinition.addOrReplaceChild("left_arm", CubeListBuilder.create().texOffs(33, 48).addBox(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.0f, (float)2.0f, (float)0.0f));
        torso.addOrReplaceChild("quiver", CubeListBuilder.create().texOffs(100, 0).addBox(-2.5f, -2.0f, 0.0f, 5.0f, 10.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)3.0f, (float)2.3f));
        head.addOrReplaceChild("nose", CubeListBuilder.create().texOffs(54, 0).addBox(-1.0f, 0.0f, -2.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-3.0f, (float)-4.0f));
        partdefinition.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(16, 48).mirror().addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-1.9f, (float)12.0f, (float)0.0f));
        partdefinition.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(16, 28).addBox(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.9f, (float)12.0f, (float)0.0f));
        leftArm.addOrReplaceChild("shoulderPad_right", CubeListBuilder.create().texOffs(72, 33).mirror().addBox(0.0f, 0.0f, -3.0f, 5.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-0.5f, (float)-3.5f, (float)0.0f));
        rightArm.addOrReplaceChild("shoulderPad_left", CubeListBuilder.create().texOffs(72, 33).addBox(-5.0f, 0.0f, -3.0f, 5.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.5f, (float)-3.5f, (float)0.0f));
        partdefinition.addOrReplaceChild("hat", CubeListBuilder.create().texOffs(0, 0).addBox(-4.5f, -11.0f, -4.5f, 9.0f, 11.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setRotateAngle(ModelPart ModelRenderer, float x, float y, float z) {
        ModelRenderer.xRot = x;
        ModelRenderer.yRot = y;
        ModelRenderer.zRot = z;
    }

    public void setupAnim(Guard entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netbipedHeadYaw, float bipedHeadPitch) {
        boolean isHoldingShootable;
        super.setupAnim((LivingEntity)entityIn, limbSwing, limbSwingAmount, ageInTicks, netbipedHeadYaw, bipedHeadPitch);
        ItemStack itemstack = entityIn.getItemInHand(InteractionHand.MAIN_HAND);
        this.quiver.visible = isHoldingShootable = itemstack.getItem() instanceof ProjectileWeaponItem;
        boolean hasChestplate = entityIn.getItemBySlot(EquipmentSlot.CHEST).getItem() instanceof ArmorItem;
        this.ArmLShoulderPad.visible = !hasChestplate;
        boolean bl = this.ArmRShoulderPad.visible = !hasChestplate;
        if (entityIn.getKickTicks() > 0) {
            float f1 = 1.0f - (float)Mth.abs((int)(10 - 2 * entityIn.getKickTicks())) / 10.0f;
            this.rightLeg.xRot = Mth.lerp((float)f1, (float)this.rightLeg.xRot, (float)-1.4f);
        }
        double speed = 0.005;
        if (this.attackTime == 0.0f && entityIn.isAggressive() && !isHoldingShootable && entityIn.getDeltaMovement().horizontalDistanceSqr() > speed && !entityIn.getMainHandItem().isEmpty() && !entityIn.isBlocking()) {
            AnimationUtils.swingWeaponDown((ModelPart)this.rightArm, (ModelPart)this.leftArm, (Mob)entityIn, (float)this.attackTime, (float)ageInTicks);
        }
        if (entityIn.getMainArm() == HumanoidArm.RIGHT) {
            this.eatingAnimationRightHand(InteractionHand.MAIN_HAND, entityIn, ageInTicks);
            this.eatingAnimationLeftHand(InteractionHand.OFF_HAND, entityIn, ageInTicks);
        } else {
            this.eatingAnimationRightHand(InteractionHand.OFF_HAND, entityIn, ageInTicks);
            this.eatingAnimationLeftHand(InteractionHand.MAIN_HAND, entityIn, ageInTicks);
        }
    }

    public void eatingAnimationRightHand(InteractionHand hand, Guard entity, float ageInTicks) {
        boolean drinkingoreating;
        ItemStack itemstack = entity.getItemInHand(hand);
        boolean bl = drinkingoreating = itemstack.getUseAnimation() == UseAnim.EAT || itemstack.getUseAnimation() == UseAnim.DRINK;
        if (entity.isEating() && drinkingoreating) {
            this.rightArm.yRot = -0.5f;
            this.rightArm.xRot = -1.3f;
            this.rightArm.zRot = Mth.cos((float)ageInTicks) * 0.1f;
            this.head.xRot = Mth.cos((float)ageInTicks) * 0.2f;
            this.head.yRot = 0.0f;
            this.hat.copyFrom(this.head);
        }
    }

    public void eatingAnimationLeftHand(InteractionHand hand, Guard entity, float ageInTicks) {
        boolean drinkingoreating;
        ItemStack itemstack = entity.getItemInHand(hand);
        boolean bl = drinkingoreating = itemstack.getUseAnimation() == UseAnim.EAT || itemstack.getUseAnimation() == UseAnim.DRINK;
        if (entity.isEating() && drinkingoreating) {
            this.leftArm.yRot = 0.5f;
            this.leftArm.xRot = -1.3f;
            this.leftArm.zRot = Mth.cos((float)ageInTicks) * 0.1f;
            this.head.xRot = Mth.cos((float)ageInTicks) * 0.2f;
            this.head.yRot = 0.0f;
            this.hat.copyFrom(this.head);
        }
    }
}

