/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import net.minecraft.client.model.HumanoidArmorModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.HumanoidMobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import tallestegg.guardvillagers.client.GuardClientEvents;
import tallestegg.guardvillagers.client.models.GuardArmorModel;
import tallestegg.guardvillagers.client.models.GuardModel;
import tallestegg.guardvillagers.client.models.GuardSteveModel;
import tallestegg.guardvillagers.configuration.GuardConfig;
import tallestegg.guardvillagers.entities.Guard;

public class GuardRenderer
extends HumanoidMobRenderer<Guard, HumanoidModel<Guard>> {
    private final HumanoidModel<Guard> steve;
    private final HumanoidModel<Guard> normal = (HumanoidModel)this.getModel();

    public GuardRenderer(EntityRendererProvider.Context context) {
        super(context, (HumanoidModel)new GuardModel(context.bakeLayer(GuardClientEvents.GUARD)), 0.5f);
        this.steve = new GuardSteveModel(context.bakeLayer(GuardClientEvents.GUARD_STEVE));
        this.model = GuardConfig.guardSteve ? this.steve : this.normal;
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, (HumanoidModel)(!GuardConfig.guardSteve ? new GuardArmorModel(context.bakeLayer(GuardClientEvents.GUARD_ARMOR_INNER)) : new HumanoidArmorModel(context.bakeLayer(ModelLayers.PLAYER_INNER_ARMOR))), (HumanoidModel)(!GuardConfig.guardSteve ? new GuardArmorModel(context.bakeLayer(GuardClientEvents.GUARD_ARMOR_OUTER)) : new HumanoidArmorModel(context.bakeLayer(ModelLayers.PLAYER_OUTER_ARMOR))), context.getModelManager()));
    }

    public void render(Guard entityIn, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        this.setModelVisibilities(entityIn);
        super.render((Mob)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    private void setModelVisibilities(Guard entityIn) {
        HumanoidModel guardmodel = (HumanoidModel)this.getModel();
        ItemStack itemstack = entityIn.getMainHandItem();
        ItemStack itemstack1 = entityIn.getOffhandItem();
        guardmodel.setAllVisible(true);
        HumanoidModel.ArmPose bipedmodel$armpose = this.getArmPose(entityIn, itemstack, itemstack1, InteractionHand.MAIN_HAND);
        HumanoidModel.ArmPose bipedmodel$armpose1 = this.getArmPose(entityIn, itemstack, itemstack1, InteractionHand.OFF_HAND);
        guardmodel.crouching = entityIn.isCrouching();
        if (entityIn.getMainArm() == HumanoidArm.RIGHT) {
            guardmodel.rightArmPose = bipedmodel$armpose;
            guardmodel.leftArmPose = bipedmodel$armpose1;
        } else {
            guardmodel.rightArmPose = bipedmodel$armpose1;
            guardmodel.leftArmPose = bipedmodel$armpose;
        }
    }

    private HumanoidModel.ArmPose getArmPose(Guard entityIn, ItemStack itemStackMain, ItemStack itemStackOff, InteractionHand handIn) {
        HumanoidModel.ArmPose bipedmodel$armpose;
        block9: {
            block10: {
                ItemStack itemstack;
                bipedmodel$armpose = HumanoidModel.ArmPose.EMPTY;
                ItemStack itemStack = itemstack = handIn == InteractionHand.MAIN_HAND ? itemStackMain : itemStackOff;
                if (itemstack.isEmpty()) break block9;
                bipedmodel$armpose = HumanoidModel.ArmPose.ITEM;
                if (entityIn.getUseItemRemainingTicks() <= 0) break block10;
                UseAnim useaction = itemstack.getUseAnimation();
                switch (useaction) {
                    case BLOCK: {
                        bipedmodel$armpose = HumanoidModel.ArmPose.BLOCK;
                        break;
                    }
                    case BOW: {
                        bipedmodel$armpose = HumanoidModel.ArmPose.BOW_AND_ARROW;
                        break;
                    }
                    case SPEAR: {
                        bipedmodel$armpose = HumanoidModel.ArmPose.THROW_SPEAR;
                        break;
                    }
                    case CROSSBOW: {
                        if (handIn == entityIn.getUsedItemHand()) {
                            bipedmodel$armpose = HumanoidModel.ArmPose.CROSSBOW_CHARGE;
                            break;
                        }
                        break block9;
                    }
                    default: {
                        bipedmodel$armpose = HumanoidModel.ArmPose.EMPTY;
                        break;
                    }
                }
                break block9;
            }
            boolean flag1 = itemStackMain.getItem() instanceof CrossbowItem;
            boolean flag2 = itemStackOff.getItem() instanceof CrossbowItem;
            if (flag1 && entityIn.isAggressive()) {
                bipedmodel$armpose = HumanoidModel.ArmPose.CROSSBOW_HOLD;
            }
            if (flag2 && itemStackMain.getItem().getUseAnimation(itemStackMain) == UseAnim.NONE && entityIn.isAggressive()) {
                bipedmodel$armpose = HumanoidModel.ArmPose.CROSSBOW_HOLD;
            }
        }
        return bipedmodel$armpose;
    }

    protected void scale(Guard entitylivingbaseIn, PoseStack matrixStackIn, float partialTickTime) {
        matrixStackIn.scale(0.9375f, 0.9375f, 0.9375f);
    }

    @Nullable
    public ResourceLocation getTextureLocation(Guard entity) {
        return !GuardConfig.guardSteve ? new ResourceLocation("guardvillagers", "textures/entity/guard/guard_" + entity.getGuardVariant() + ".png") : new ResourceLocation("guardvillagers", "textures/entity/guard/guard_steve_" + entity.getGuardVariant() + ".png");
    }
}

