/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.entities;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GolemRandomStrollInVillageGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveBackToVillageGoal;
import net.minecraft.world.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.world.entity.ai.goal.RangedBowAttackGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.gossip.GossipContainer;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.PolarBear;
import net.minecraft.world.entity.monster.CrossbowAttackMob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.ToolActions;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import tallestegg.guardvillagers.GuardItems;
import tallestegg.guardvillagers.GuardLootTables;
import tallestegg.guardvillagers.GuardPacketHandler;
import tallestegg.guardvillagers.client.GuardSounds;
import tallestegg.guardvillagers.configuration.GuardConfig;
import tallestegg.guardvillagers.entities.GuardContainer;
import tallestegg.guardvillagers.entities.ai.goals.ArmorerRepairGuardArmorGoal;
import tallestegg.guardvillagers.entities.ai.goals.FollowShieldGuards;
import tallestegg.guardvillagers.entities.ai.goals.GuardEatFoodGoal;
import tallestegg.guardvillagers.entities.ai.goals.GuardInteractDoorGoal;
import tallestegg.guardvillagers.entities.ai.goals.GuardLookAtAndStopMovingWhenBeingTheInteractionTarget;
import tallestegg.guardvillagers.entities.ai.goals.GuardRunToEatGoal;
import tallestegg.guardvillagers.entities.ai.goals.HeroHurtByTargetGoal;
import tallestegg.guardvillagers.entities.ai.goals.HeroHurtTargetGoal;
import tallestegg.guardvillagers.entities.ai.goals.KickGoal;
import tallestegg.guardvillagers.entities.ai.goals.RaiseShieldGoal;
import tallestegg.guardvillagers.entities.ai.goals.RangedCrossbowAttackPassiveGoal;
import tallestegg.guardvillagers.entities.ai.goals.RunToClericGoal;
import tallestegg.guardvillagers.entities.ai.goals.WalkBackToCheckPointGoal;
import tallestegg.guardvillagers.networking.GuardOpenInventoryPacket;

public class Guard
extends PathfinderMob
implements CrossbowAttackMob,
RangedAttackMob,
NeutralMob,
ContainerListener,
ReputationEventHandler {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.defineId(Guard.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    private static final UUID MODIFIER_UUID = UUID.fromString("5CD17E52-A79A-43D3-A529-90FDE04B181E");
    private static final AttributeModifier USE_ITEM_SPEED_PENALTY = new AttributeModifier(MODIFIER_UUID, "Use item speed penalty", -0.25, AttributeModifier.Operation.ADDITION);
    private static final EntityDataAccessor<Optional<BlockPos>> GUARD_POS = SynchedEntityData.defineId(Guard.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_BLOCK_POS);
    private static final EntityDataAccessor<Boolean> PATROLLING = SynchedEntityData.defineId(Guard.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Integer> GUARD_VARIANT = SynchedEntityData.defineId(Guard.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> RUNNING_TO_EAT = SynchedEntityData.defineId(Guard.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> DATA_CHARGING_STATE = SynchedEntityData.defineId(Guard.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> KICKING = SynchedEntityData.defineId(Guard.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> FOLLOWING = SynchedEntityData.defineId(Guard.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final Map<Pose, EntityDimensions> SIZE_BY_POSE = ImmutableMap.builder().put((Object)Pose.STANDING, (Object)EntityDimensions.scalable((float)0.6f, (float)1.95f)).put((Object)Pose.SLEEPING, (Object)SLEEPING_DIMENSIONS).put((Object)Pose.FALL_FLYING, (Object)EntityDimensions.scalable((float)0.6f, (float)0.6f)).put((Object)Pose.SWIMMING, (Object)EntityDimensions.scalable((float)0.6f, (float)0.6f)).put((Object)Pose.SPIN_ATTACK, (Object)EntityDimensions.scalable((float)0.6f, (float)0.6f)).put((Object)Pose.CROUCHING, (Object)EntityDimensions.scalable((float)0.6f, (float)1.75f)).put((Object)Pose.DYING, (Object)EntityDimensions.fixed((float)0.2f, (float)0.2f)).build();
    private static final UniformInt angerTime = TimeUtil.rangeOfSeconds((int)20, (int)39);
    private static final Map<EquipmentSlot, ResourceLocation> EQUIPMENT_SLOT_ITEMS = (Map)Util.make((Object)Maps.newHashMap(), slotItems -> {
        slotItems.put(EquipmentSlot.MAINHAND, GuardLootTables.GUARD_MAIN_HAND);
        slotItems.put(EquipmentSlot.OFFHAND, GuardLootTables.GUARD_OFF_HAND);
        slotItems.put(EquipmentSlot.HEAD, GuardLootTables.GUARD_HELMET);
        slotItems.put(EquipmentSlot.CHEST, GuardLootTables.GUARD_CHEST);
        slotItems.put(EquipmentSlot.LEGS, GuardLootTables.GUARD_LEGGINGS);
        slotItems.put(EquipmentSlot.FEET, GuardLootTables.GUARD_FEET);
    });
    private final GossipContainer gossips = new GossipContainer();
    public long lastGossipTime;
    public long lastGossipDecayTime;
    public SimpleContainer guardInventory = new SimpleContainer(6);
    public int kickTicks;
    public int shieldCoolDown;
    public int kickCoolDown;
    public boolean interacting;
    protected boolean spawnWithArmor;
    private int remainingPersistentAngerTime;
    private UUID persistentAngerTarget;

    public Guard(EntityType<? extends Guard> type, Level world) {
        super(type, world);
        this.guardInventory.addListener((ContainerListener)this);
        this.setPersistenceRequired();
        if (GuardConfig.GuardsOpenDoors) {
            ((GroundPathNavigation)this.getNavigation()).setCanOpenDoors(true);
        }
    }

    public static int slotToInventoryIndex(EquipmentSlot slot) {
        switch (slot) {
            case CHEST: {
                return 1;
            }
            case FEET: {
                return 3;
            }
            case HEAD: {
                return 0;
            }
            case LEGS: {
                return 2;
            }
        }
        return 0;
    }

    public static int getRandomTypeForBiome(LevelAccessor world, BlockPos pos) {
        VillagerType type = VillagerType.byBiome((Holder)world.getBiome(pos));
        if (type == VillagerType.SNOW) {
            return 6;
        }
        if (type == VillagerType.TAIGA) {
            return 5;
        }
        if (type == VillagerType.JUNGLE) {
            return 4;
        }
        if (type == VillagerType.SWAMP) {
            return 3;
        }
        if (type == VillagerType.SAVANNA) {
            return 2;
        }
        if (type == VillagerType.DESERT) {
            return 1;
        }
        return 0;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, ((Double)GuardConfig.COMMON.healthModifier.get()).doubleValue()).add(Attributes.MOVEMENT_SPEED, ((Double)GuardConfig.COMMON.speedModifier.get()).doubleValue()).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.FOLLOW_RANGE, ((Double)GuardConfig.COMMON.followRangeModifier.get()).doubleValue());
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.setPersistenceRequired();
        int type = Guard.getRandomTypeForBiome((LevelAccessor)this.level(), this.blockPosition());
        if (spawnDataIn instanceof GuardData) {
            type = ((GuardData)spawnDataIn).variantData;
            spawnDataIn = new GuardData(type);
        }
        this.setGuardVariant(type);
        RandomSource randomsource = worldIn.getRandom();
        this.populateDefaultEquipmentSlots(randomsource, difficultyIn);
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void doPush(Entity entityIn) {
        if (entityIn instanceof PathfinderMob) {
            boolean attackTargets;
            PathfinderMob living = (PathfinderMob)entityIn;
            boolean bl = attackTargets = living.getTarget() instanceof Villager || living.getTarget() instanceof IronGolem || living.getTarget() instanceof Guard;
            if (attackTargets) {
                this.setTarget((LivingEntity)living);
            }
        }
        super.doPush(entityIn);
    }

    @Nullable
    public BlockPos getPatrolPos() {
        return ((Optional)this.entityData.get(GUARD_POS)).orElse(null);
    }

    @Nullable
    public void setPatrolPos(BlockPos position) {
        this.entityData.set(GUARD_POS, Optional.ofNullable(position));
    }

    protected SoundEvent getAmbientSound() {
        return (SoundEvent)GuardSounds.GUARD_AMBIENT.value();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        if (this.isBlocking()) {
            return SoundEvents.SHIELD_BLOCK;
        }
        return (SoundEvent)GuardSounds.GUARD_HURT.value();
    }

    protected SoundEvent getDeathSound() {
        return (SoundEvent)GuardSounds.GUARD_DEATH.value();
    }

    protected void dropCustomDeathLoot(DamageSource source, int looting, boolean recentlyHitIn) {
        for (int i = 0; i < this.guardInventory.getContainerSize(); ++i) {
            ItemStack itemstack = this.guardInventory.getItem(i);
            RandomSource randomsource = this.level().getRandom();
            if (itemstack.isEmpty() || EnchantmentHelper.hasVanishingCurse((ItemStack)itemstack) || !(randomsource.nextFloat() < ((Double)GuardConfig.COMMON.chanceToDropEquipment.get()).floatValue())) continue;
            this.spawnAtLocation(itemstack);
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        UUID uuid;
        super.readAdditionalSaveData(compound);
        UUID uUID = uuid = compound.hasUUID("Owner") ? compound.getUUID("Owner") : null;
        if (uuid != null) {
            try {
                this.setOwnerId(uuid);
            }
            catch (Throwable throwable) {
                this.setOwnerId(null);
            }
        }
        this.setGuardVariant(compound.getInt("Type"));
        this.kickTicks = compound.getInt("KickTicks");
        this.setFollowing(compound.getBoolean("Following"));
        this.interacting = compound.getBoolean("Interacting");
        this.setPatrolling(compound.getBoolean("Patrolling"));
        this.shieldCoolDown = compound.getInt("KickCooldown");
        this.kickCoolDown = compound.getInt("ShieldCooldown");
        this.lastGossipDecayTime = compound.getLong("LastGossipDecay");
        this.lastGossipTime = compound.getLong("LastGossipTime");
        this.spawnWithArmor = compound.getBoolean("SpawnWithArmor");
        if (compound.contains("PatrolPosX")) {
            int x = compound.getInt("PatrolPosX");
            int y = compound.getInt("PatrolPosY");
            int z = compound.getInt("PatrolPosZ");
            this.entityData.set(GUARD_POS, Optional.ofNullable(new BlockPos(x, y, z)));
        }
        ListTag listtag = compound.getList("Gossips", 10);
        this.gossips.update(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)listtag));
        ListTag listnbt = compound.getList("Inventory", 9);
        for (int i = 0; i < listnbt.size(); ++i) {
            CompoundTag compoundnbt = listnbt.getCompound(i);
            int j = compoundnbt.getByte("Slot") & 0xFF;
            this.guardInventory.setItem(j, ItemStack.of((CompoundTag)compoundnbt));
        }
        if (compound.contains("ArmorItems", 9)) {
            ListTag armorItems = compound.getList("ArmorItems", 10);
            for (int i = 0; i < this.armorItems.size(); ++i) {
                int index = Guard.slotToInventoryIndex(Mob.getEquipmentSlotForItem((ItemStack)ItemStack.of((CompoundTag)armorItems.getCompound(i))));
                this.guardInventory.setItem(index, ItemStack.of((CompoundTag)armorItems.getCompound(i)));
            }
        }
        if (compound.contains("HandItems", 9)) {
            ListTag handItems = compound.getList("HandItems", 10);
            for (int i = 0; i < this.handItems.size(); ++i) {
                int handSlot = i == 0 ? 5 : 4;
                this.guardInventory.setItem(handSlot, ItemStack.of((CompoundTag)handItems.getCompound(i)));
            }
        }
        if (!this.level().isClientSide) {
            this.readPersistentAngerSaveData(this.level(), compound);
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("Type", this.getGuardVariant());
        compound.putInt("KickTicks", this.kickTicks);
        compound.putInt("ShieldCooldown", this.shieldCoolDown);
        compound.putInt("KickCooldown", this.kickCoolDown);
        compound.putBoolean("Following", this.isFollowing());
        compound.putBoolean("Interacting", this.interacting);
        compound.putBoolean("Patrolling", this.isPatrolling());
        compound.putBoolean("SpawnWithArmor", this.spawnWithArmor);
        compound.putLong("LastGossipTime", this.lastGossipTime);
        compound.putLong("LastGossipDecay", this.lastGossipDecayTime);
        if (this.getOwnerId() != null) {
            compound.putUUID("Owner", this.getOwnerId());
        }
        ListTag listnbt = new ListTag();
        for (int i = 0; i < this.guardInventory.getContainerSize(); ++i) {
            ItemStack itemstack = this.guardInventory.getItem(i);
            if (itemstack.isEmpty()) continue;
            CompoundTag compoundnbt = new CompoundTag();
            compoundnbt.putByte("Slot", (byte)i);
            itemstack.save(compoundnbt);
            listnbt.add((Object)compoundnbt);
        }
        compound.put("Inventory", (Tag)listnbt);
        if (this.getPatrolPos() != null) {
            compound.putInt("PatrolPosX", this.getPatrolPos().getX());
            compound.putInt("PatrolPosY", this.getPatrolPos().getY());
            compound.putInt("PatrolPosZ", this.getPatrolPos().getZ());
        }
        compound.put("Gossips", (Tag)this.gossips.store((DynamicOps)NbtOps.INSTANCE));
        this.addPersistentAngerSaveData(compound);
    }

    private void maybeDecayGossip() {
        long i = this.level().getGameTime();
        if (this.lastGossipDecayTime == 0L) {
            this.lastGossipDecayTime = i;
        } else if (i >= this.lastGossipDecayTime + 24000L) {
            this.gossips.decay();
            this.lastGossipDecayTime = i;
        }
    }

    protected void completeUsingItem() {
        if (this.isUsingItem()) {
            InteractionHand interactionhand = this.getUsedItemHand();
            if (!this.useItem.equals(this.getItemInHand(interactionhand))) {
                this.releaseUsingItem();
            } else if (!this.useItem.isEmpty() && this.isUsingItem()) {
                this.triggerItemUseEffects(this.useItem, 16);
                ItemStack copy = this.useItem.copy();
                ItemStack itemstack = EventHooks.onItemUseFinish((LivingEntity)this, (ItemStack)copy, (int)this.getUseItemRemainingTicks(), (ItemStack)this.useItem.finishUsingItem(this.level(), (LivingEntity)this));
                if (itemstack != this.useItem) {
                    this.setItemInHand(interactionhand, itemstack);
                }
                if (!this.useItem.isEdible()) {
                    this.useItem.shrink(1);
                }
                this.stopUsingItem();
            }
        }
    }

    public ItemStack getItemBySlot(EquipmentSlot pSlot) {
        switch (pSlot) {
            case HEAD: {
                return this.guardInventory.getItem(0);
            }
            case CHEST: {
                return this.guardInventory.getItem(1);
            }
            case LEGS: {
                return this.guardInventory.getItem(2);
            }
            case FEET: {
                return this.guardInventory.getItem(3);
            }
            case OFFHAND: {
                return this.guardInventory.getItem(4);
            }
            case MAINHAND: {
                return this.guardInventory.getItem(5);
            }
        }
        return ItemStack.EMPTY;
    }

    public GossipContainer getGossips() {
        return this.gossips;
    }

    public int getPlayerReputation(Player player) {
        return this.gossips.getReputation(player.getUUID(), gossipType -> true);
    }

    @Nullable
    public LivingEntity getOwner() {
        try {
            UUID uuid = this.getOwnerId();
            boolean heroOfTheVillage = uuid != null && this.level().getPlayerByUUID(uuid) != null && this.level().getPlayerByUUID(uuid).hasEffect(MobEffects.HERO_OF_THE_VILLAGE);
            return uuid == null || this.level().getPlayerByUUID(uuid) != null && !heroOfTheVillage && GuardConfig.followHero || !GuardConfig.followHero && this.level().getPlayerByUUID(uuid) == null ? null : this.level().getPlayerByUUID(uuid);
        }
        catch (IllegalArgumentException illegalargumentexception) {
            return null;
        }
    }

    public boolean isOwner(LivingEntity entityIn) {
        return entityIn == this.getOwner();
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.entityData.get(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.entityData.set(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    public boolean doHurtTarget(Entity entityIn) {
        if (this.isKicking()) {
            ((LivingEntity)entityIn).knockback(1.0, (double)Mth.sin((float)(this.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(this.getYRot() * ((float)Math.PI / 180)))));
            this.kickTicks = 10;
            this.level().broadcastEntityEvent((Entity)this, (byte)4);
            this.lookAt(entityIn, 90.0f, 90.0f);
        }
        ItemStack hand = this.getMainHandItem();
        hand.hurtAndBreak(1, (LivingEntity)this, entity -> entity.broadcastBreakEvent(EquipmentSlot.MAINHAND));
        return super.doHurtTarget(entityIn);
    }

    public void handleEntityEvent(byte id) {
        if (id == 4) {
            this.kickTicks = 10;
        } else {
            super.handleEntityEvent(id);
        }
    }

    public boolean isImmobile() {
        return this.interacting || super.isImmobile();
    }

    public void die(DamageSource source) {
        if ((this.level().getDifficulty() == Difficulty.NORMAL || this.level().getDifficulty() == Difficulty.HARD) && source.getEntity() instanceof Zombie && EventHooks.canLivingConvert((LivingEntity)((LivingEntity)source.getEntity()), (EntityType)EntityType.ZOMBIE_VILLAGER, timer -> {})) {
            ZombieVillager zombieguard = (ZombieVillager)this.convertTo(EntityType.ZOMBIE_VILLAGER, true);
            if (this.level().getDifficulty() != Difficulty.HARD && this.random.nextBoolean() || zombieguard == null) {
                return;
            }
            zombieguard.finalizeSpawn((ServerLevelAccessor)this.level(), this.level().getCurrentDifficultyAt(zombieguard.blockPosition()), MobSpawnType.CONVERSION, (SpawnGroupData)new Zombie.ZombieGroupData(false, true), (CompoundTag)null);
            if (!this.isSilent()) {
                this.level().levelEvent(null, 1026, this.blockPosition(), 0);
            }
            this.discard();
        }
        super.die(source);
    }

    public ItemStack eat(Level world, ItemStack stack) {
        if (stack.isEdible()) {
            this.heal(stack.getItem().getFoodProperties(stack, (LivingEntity)this).getNutrition());
        }
        world.playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.PLAYER_BURP, SoundSource.PLAYERS, 0.5f, world.random.nextFloat() * 0.1f + 0.9f);
        super.eat(world, stack);
        return stack;
    }

    public void aiStep() {
        if (this.kickTicks > 0) {
            --this.kickTicks;
        }
        if (this.kickCoolDown > 0) {
            --this.kickCoolDown;
        }
        if (this.shieldCoolDown > 0) {
            --this.shieldCoolDown;
        }
        if (this.getHealth() < this.getMaxHealth() && this.tickCount % 200 == 0) {
            this.heal(GuardConfig.amountOfHealthRegenerated);
        }
        if (this.spawnWithArmor) {
            for (EquipmentSlot equipmentslottype : EquipmentSlot.values()) {
                for (ItemStack stack : this.getItemsFromLootTable(equipmentslottype, (ServerLevel)this.level())) {
                    this.setItemSlot(equipmentslottype, stack);
                }
            }
            this.spawnWithArmor = false;
        }
        if (!this.level().isClientSide) {
            this.updatePersistentAnger((ServerLevel)this.level(), true);
        }
        this.updateSwingTime();
        super.aiStep();
    }

    public void tick() {
        this.maybeDecayGossip();
        super.tick();
    }

    public EntityDimensions getDimensions(Pose poseIn) {
        return SIZE_BY_POSE.getOrDefault(poseIn, EntityDimensions.scalable((float)0.6f, (float)1.95f));
    }

    public float getStandingEyeHeight(Pose poseIn, EntityDimensions sizeIn) {
        if (poseIn == Pose.CROUCHING) {
            return 1.4f;
        }
        return super.getStandingEyeHeight(poseIn, sizeIn);
    }

    protected void blockUsingShield(LivingEntity entityIn) {
        super.blockUsingShield(entityIn);
        if (entityIn.getMainHandItem().canDisableShield(this.useItem, (LivingEntity)this, entityIn)) {
            this.disableShield(true);
        }
    }

    protected void hurtCurrentlyUsedShield(float damage) {
        if (this.useItem.canPerformAction(ToolActions.SHIELD_BLOCK) && damage >= 3.0f) {
            int i = 1 + Mth.floor((float)damage);
            InteractionHand hand = this.getUsedItemHand();
            this.useItem.hurtAndBreak(i, (LivingEntity)this, entity -> entity.broadcastBreakEvent(hand));
            if (this.useItem.isEmpty()) {
                if (hand == InteractionHand.MAIN_HAND) {
                    this.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
                } else {
                    this.setItemSlot(EquipmentSlot.OFFHAND, ItemStack.EMPTY);
                }
                this.useItem = ItemStack.EMPTY;
                this.playSound(SoundEvents.SHIELD_BREAK, 0.8f, 0.8f + this.level().random.nextFloat() * 0.4f);
            }
        }
    }

    public void startUsingItem(InteractionHand hand) {
        super.startUsingItem(hand);
        ItemStack itemstack = this.getItemInHand(hand);
        if (itemstack.canPerformAction(ToolActions.SHIELD_BLOCK)) {
            AttributeInstance modifiableattributeinstance = this.getAttribute(Attributes.MOVEMENT_SPEED);
            modifiableattributeinstance.removeModifier(USE_ITEM_SPEED_PENALTY.getId());
            modifiableattributeinstance.addTransientModifier(USE_ITEM_SPEED_PENALTY);
        }
    }

    public void stopUsingItem() {
        super.stopUsingItem();
        if (this.getAttribute(Attributes.MOVEMENT_SPEED).hasModifier(USE_ITEM_SPEED_PENALTY)) {
            this.getAttribute(Attributes.MOVEMENT_SPEED).removeModifier(USE_ITEM_SPEED_PENALTY.getId());
        }
    }

    public void disableShield(boolean increase) {
        float chance = 0.25f + (float)EnchantmentHelper.getBlockEfficiency((LivingEntity)this) * 0.05f;
        if (increase) {
            chance = (float)((double)chance + 0.75);
        }
        if (this.random.nextFloat() < chance) {
            this.shieldCoolDown = 100;
            this.stopUsingItem();
            this.level().broadcastEntityEvent((Entity)this, (byte)30);
        }
    }

    protected void defineSynchedData() {
        super.defineSynchedData();
        this.entityData.define(GUARD_VARIANT, (Object)0);
        this.entityData.define(DATA_CHARGING_STATE, (Object)false);
        this.entityData.define(KICKING, (Object)false);
        this.entityData.define(OWNER_UNIQUE_ID, Optional.empty());
        this.entityData.define(FOLLOWING, (Object)false);
        this.entityData.define(GUARD_POS, Optional.empty());
        this.entityData.define(PATROLLING, (Object)false);
        this.entityData.define(RUNNING_TO_EAT, (Object)false);
    }

    public boolean isCharging() {
        return (Boolean)this.entityData.get(DATA_CHARGING_STATE);
    }

    public void setChargingCrossbow(boolean charging) {
        this.entityData.set(DATA_CHARGING_STATE, (Object)charging);
    }

    public boolean isKicking() {
        return (Boolean)this.entityData.get(KICKING);
    }

    public void setKicking(boolean kicking) {
        this.entityData.set(KICKING, (Object)kicking);
    }

    protected void populateDefaultEquipmentSlots(RandomSource source, DifficultyInstance instance) {
        this.handDropChances[EquipmentSlot.MAINHAND.getIndex()] = 100.0f;
        this.handDropChances[EquipmentSlot.OFFHAND.getIndex()] = 100.0f;
        this.spawnWithArmor = true;
    }

    public List<ItemStack> getItemsFromLootTable(EquipmentSlot slot, ServerLevel level) {
        if (EQUIPMENT_SLOT_ITEMS.containsKey(slot)) {
            ServerLevel serverlevel = (ServerLevel)this.level();
            LootTable loot = serverlevel.getServer().getLootData().getLootTable(EQUIPMENT_SLOT_ITEMS.get(slot));
            LootParams.Builder lootcontext$builder = new LootParams.Builder(level).withParameter(LootContextParams.THIS_ENTITY, (Object)this);
            return loot.getRandomItems(lootcontext$builder.create(GuardLootTables.SLOT));
        }
        return null;
    }

    public int getGuardVariant() {
        return (Integer)this.entityData.get(GUARD_VARIANT);
    }

    public void setGuardVariant(int typeId) {
        this.entityData.set(GUARD_VARIANT, (Object)typeId);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(0, (Goal)new KickGoal(this));
        this.goalSelector.addGoal(0, (Goal)new GuardEatFoodGoal(this));
        this.goalSelector.addGoal(0, (Goal)new RaiseShieldGoal(this));
        this.goalSelector.addGoal(1, (Goal)new GuardRunToEatGoal(this));
        this.goalSelector.addGoal(3, new RangedCrossbowAttackPassiveGoal<Guard>(this, 1.0, 8.0f));
        this.goalSelector.addGoal(3, (Goal)new RangedBowAttackGoal((Mob)this, 0.5, 20, 15.0f){

            public boolean canUse() {
                return Guard.this.getTarget() != null && this.isBowInMainhand() && !Guard.this.isEating() && !Guard.this.isBlocking();
            }

            protected boolean isBowInMainhand() {
                return Guard.this.getMainHandItem().getItem() instanceof BowItem;
            }

            public void tick() {
                super.tick();
                if (Guard.this.isPatrolling()) {
                    Guard.this.getNavigation().stop();
                    Guard.this.getMoveControl().strafe(0.0f, 0.0f);
                }
            }

            public boolean canContinueToUse() {
                return (this.canUse() || !Guard.this.getNavigation().isDone()) && this.isBowInMainhand();
            }
        });
        this.goalSelector.addGoal(3, (Goal)new GuardMeleeGoal(this, 0.8, true));
        this.goalSelector.addGoal(4, (Goal)new FollowHeroGoal(this));
        if (GuardConfig.GuardsRunFromPolarBears) {
            this.goalSelector.addGoal(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, PolarBear.class, 12.0f, 1.0, 1.2));
        }
        this.goalSelector.addGoal(4, (Goal)new MoveBackToVillageGoal((PathfinderMob)this, 0.5, false));
        if (GuardConfig.GuardsOpenDoors) {
            this.goalSelector.addGoal(4, (Goal)new GuardInteractDoorGoal(this, true));
        }
        if (GuardConfig.GuardFormation) {
            this.goalSelector.addGoal(6, (Goal)new FollowShieldGuards(this));
        }
        if (GuardConfig.ClericHealing) {
            this.goalSelector.addGoal(6, (Goal)new RunToClericGoal(this));
        }
        if (GuardConfig.armorerRepairGuardArmor) {
            this.goalSelector.addGoal(6, (Goal)new ArmorerRepairGuardArmorGoal(this));
        }
        this.goalSelector.addGoal(4, (Goal)new WalkBackToCheckPointGoal(this, 0.5));
        this.goalSelector.addGoal(5, (Goal)new GolemRandomStrollInVillageGoal((PathfinderMob)this, 0.5));
        this.goalSelector.addGoal(5, (Goal)new MoveThroughVillageGoal((PathfinderMob)this, 0.5, false, 4, () -> false));
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, AbstractVillager.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new GuardLookAtAndStopMovingWhenBeingTheInteractionTarget(this));
        this.targetSelector.addGoal(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Guard.class, IronGolem.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(3, (Goal)new HeroHurtByTargetGoal(this));
        this.targetSelector.addGoal(3, (Goal)new HeroHurtTargetGoal(this));
        this.targetSelector.addGoal(5, (Goal)new DefendVillageGuardGoal(this));
        if (GuardConfig.AttackAllMobs) {
            this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, true, true, mob -> mob instanceof Enemy && !GuardConfig.MobBlackList.contains(mob.getEncodeId())));
        } else {
            this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Ravager.class, true));
            this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Witch.class, true));
            this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
            this.targetSelector.addGoal(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Zombie.class, true));
        }
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 5, true, true, mob -> ((List)GuardConfig.COMMON.MobWhiteList.get()).contains(mob.getEncodeId())));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((Guard)this).isAngryAt(arg_0)));
        this.targetSelector.addGoal(4, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    public boolean canBeLeashed(Player player) {
        return false;
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        this.shieldCoolDown = 8;
        if (this.getMainHandItem().getItem() instanceof CrossbowItem) {
            this.performCrossbowAttack((LivingEntity)this, 6.0f);
        }
        if (this.getMainHandItem().getItem() instanceof BowItem) {
            int punchLevel;
            ItemStack itemstack = this.getProjectile(this.getItemInHand(GuardItems.getHandWith((LivingEntity)this, (com.google.common.base.Predicate<Item>)((com.google.common.base.Predicate)item -> item instanceof BowItem))));
            ItemStack hand = this.getMainHandItem();
            AbstractArrow abstractarrowentity = ProjectileUtil.getMobArrow((LivingEntity)this, (ItemStack)itemstack, (float)distanceFactor);
            abstractarrowentity = ((BowItem)this.getMainHandItem().getItem()).customArrow(abstractarrowentity);
            int powerLevel = itemstack.getEnchantmentLevel(Enchantments.POWER_ARROWS);
            if (powerLevel > 0) {
                abstractarrowentity.setBaseDamage(abstractarrowentity.getBaseDamage() + (double)powerLevel * 0.5 + 0.5);
            }
            if ((punchLevel = itemstack.getEnchantmentLevel(Enchantments.PUNCH_ARROWS)) > 0) {
                abstractarrowentity.setKnockback(punchLevel);
            }
            if (itemstack.getEnchantmentLevel(Enchantments.FLAMING_ARROWS) > 0) {
                abstractarrowentity.setSecondsOnFire(100);
            }
            double d0 = target.getX() - this.getX();
            double d1 = target.getY(0.3333333333333333) - abstractarrowentity.getY();
            double d2 = target.getZ() - this.getZ();
            double d3 = Mth.sqrt((float)((float)(d0 * d0 + d2 * d2)));
            abstractarrowentity.shoot(d0, d1 + d3 * (double)0.2f, d2, 1.6f, (float)(14 - this.level().getDifficulty().getId() * 4));
            this.playSound(SoundEvents.ARROW_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
            this.level().addFreshEntity((Entity)abstractarrowentity);
            hand.hurtAndBreak(1, (LivingEntity)this, entity -> entity.broadcastBreakEvent(EquipmentSlot.MAINHAND));
        }
    }

    public void setItemSlot(EquipmentSlot slotIn, ItemStack stack) {
        super.setItemSlot(slotIn, stack);
        switch (slotIn) {
            case CHEST: {
                if (!this.guardInventory.getItem(1).isEmpty()) break;
                this.guardInventory.setItem(1, (ItemStack)this.armorItems.get(slotIn.getIndex()));
                break;
            }
            case FEET: {
                if (!this.guardInventory.getItem(3).isEmpty()) break;
                this.guardInventory.setItem(3, (ItemStack)this.armorItems.get(slotIn.getIndex()));
                break;
            }
            case HEAD: {
                if (!this.guardInventory.getItem(0).isEmpty()) break;
                this.guardInventory.setItem(0, (ItemStack)this.armorItems.get(slotIn.getIndex()));
                break;
            }
            case LEGS: {
                if (!this.guardInventory.getItem(2).isEmpty()) break;
                this.guardInventory.setItem(2, (ItemStack)this.armorItems.get(slotIn.getIndex()));
                break;
            }
            case MAINHAND: {
                this.guardInventory.setItem(5, (ItemStack)this.handItems.get(slotIn.getIndex()));
                break;
            }
            case OFFHAND: {
                this.guardInventory.setItem(4, (ItemStack)this.handItems.get(slotIn.getIndex()));
            }
        }
    }

    public ItemStack getProjectile(ItemStack shootable) {
        if (shootable.getItem() instanceof ProjectileWeaponItem) {
            Predicate predicate = ((ProjectileWeaponItem)shootable.getItem()).getSupportedHeldProjectiles();
            ItemStack itemstack = ProjectileWeaponItem.getHeldProjectile((LivingEntity)this, (Predicate)predicate);
            return itemstack.isEmpty() ? new ItemStack((ItemLike)Items.ARROW) : itemstack;
        }
        return ItemStack.EMPTY;
    }

    public int getKickTicks() {
        return this.kickTicks;
    }

    public boolean isFollowing() {
        return (Boolean)this.entityData.get(FOLLOWING);
    }

    public void setFollowing(boolean following) {
        this.entityData.set(FOLLOWING, (Object)following);
    }

    public boolean canAttack(LivingEntity target) {
        return GuardConfig.MobBlackList.contains(target.getEncodeId()) || target.hasEffect(MobEffects.HERO_OF_THE_VILLAGE) || this.isOwner(target) ? false : super.canAttack(target);
    }

    public void rideTick() {
        super.rideTick();
        if (this.getVehicle() instanceof PathfinderMob) {
            PathfinderMob creatureentity = (PathfinderMob)this.getVehicle();
            this.yBodyRot = creatureentity.yBodyRot;
        }
    }

    protected float ridingOffset(Entity p_297913_) {
        return -0.35f;
    }

    public void onCrossbowAttackPerformed() {
        this.noActionTime = 0;
    }

    public void setTarget(LivingEntity entity) {
        if (entity != null && (GuardConfig.MobBlackList.contains(entity.getEncodeId()) || entity.hasEffect(MobEffects.HERO_OF_THE_VILLAGE) || this.isOwner(entity))) {
            return;
        }
        super.setTarget(entity);
    }

    public void gossip(Villager villager, long gameTime) {
        if (!(gameTime >= this.lastGossipTime && gameTime < this.lastGossipTime + 1200L || gameTime >= villager.lastGossipTime && gameTime < villager.lastGossipTime + 1200L)) {
            this.gossips.transferFrom(villager.getGossips(), this.random, 10);
            this.lastGossipTime = gameTime;
            villager.lastGossipTime = gameTime;
        }
    }

    public void shootCrossbowProjectile(LivingEntity arg0, ItemStack arg1, Projectile arg2, float arg3) {
        this.shootCrossbowProjectile((LivingEntity)this, arg0, arg2, arg3, 1.6f);
    }

    protected void blockedByShield(LivingEntity entityIn) {
        if (this.isKicking()) {
            this.setKicking(false);
        }
        super.blockedByShield((LivingEntity)this);
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        boolean inventoryRequirements;
        boolean configValues = player.hasEffect(MobEffects.HERO_OF_THE_VILLAGE) && GuardConfig.giveGuardStuffHOTV || player.hasEffect(MobEffects.HERO_OF_THE_VILLAGE) && GuardConfig.setGuardPatrolHotv || player.hasEffect(MobEffects.HERO_OF_THE_VILLAGE) && GuardConfig.giveGuardStuffHOTV && GuardConfig.setGuardPatrolHotv || this.getPlayerReputation(player) >= GuardConfig.reputationRequirement || player.hasEffect(MobEffects.HERO_OF_THE_VILLAGE) && !GuardConfig.giveGuardStuffHOTV && !GuardConfig.setGuardPatrolHotv || this.getOwnerId() != null && this.getOwnerId().equals(player.getUUID());
        boolean bl = inventoryRequirements = !player.isSecondaryUseActive();
        if (inventoryRequirements) {
            if (this.getTarget() != player && this.isEffectiveAi() && configValues && player instanceof ServerPlayer) {
                this.openGui((ServerPlayer)player);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        return super.mobInteract(player, hand);
    }

    public void onReputationEventFrom(ReputationEventType reputationEventType, Entity entity) {
    }

    public void containerChanged(Container invBasic) {
    }

    protected void hurtArmor(DamageSource damageSource, float damage) {
        if (damage >= 0.0f) {
            if ((damage /= 4.0f) < 1.0f) {
                damage = 1.0f;
            }
            for (int i = 0; i < this.guardInventory.getContainerSize(); ++i) {
                ItemStack itemstack = this.guardInventory.getItem(i);
                if (damageSource.is(DamageTypes.ON_FIRE) && itemstack.getItem().isFireResistant() || !(itemstack.getItem() instanceof ArmorItem)) continue;
                int j = i;
                itemstack.hurtAndBreak((int)damage, (LivingEntity)this, p_214023_1_ -> p_214023_1_.broadcastBreakEvent(EquipmentSlot.byTypeAndIndex((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)j)));
            }
        }
    }

    public void thunderHit(ServerLevel p_241841_1_, LightningBolt p_241841_2_) {
        if (p_241841_1_.getDifficulty() != Difficulty.PEACEFUL && EventHooks.canLivingConvert((LivingEntity)this, (EntityType)EntityType.WITCH, timer -> {})) {
            Witch witchentity = (Witch)EntityType.WITCH.create((Level)p_241841_1_);
            if (witchentity == null) {
                return;
            }
            witchentity.copyPosition((Entity)this);
            witchentity.finalizeSpawn((ServerLevelAccessor)p_241841_1_, p_241841_1_.getCurrentDifficultyAt(witchentity.blockPosition()), MobSpawnType.CONVERSION, null, null);
            witchentity.setNoAi(this.isNoAi());
            witchentity.setCustomName(this.getCustomName());
            witchentity.setCustomNameVisible(this.isCustomNameVisible());
            witchentity.setPersistenceRequired();
            p_241841_1_.addFreshEntityWithPassengers((Entity)witchentity);
            this.discard();
        } else {
            super.thunderHit(p_241841_1_, p_241841_2_);
        }
    }

    public UUID getPersistentAngerTarget() {
        return this.persistentAngerTarget;
    }

    public void setPersistentAngerTarget(UUID arg0) {
        this.persistentAngerTarget = arg0;
    }

    public int getRemainingPersistentAngerTime() {
        return this.remainingPersistentAngerTime;
    }

    public void setRemainingPersistentAngerTime(int arg0) {
        this.remainingPersistentAngerTime = arg0;
    }

    public void startPersistentAngerTimer() {
        this.setRemainingPersistentAngerTime(angerTime.sample(this.random));
    }

    public void openGui(ServerPlayer player) {
        this.setOwnerId(player.getUUID());
        if (player.containerMenu != player.inventoryMenu) {
            player.closeContainer();
        }
        this.interacting = true;
        player.nextContainerCounter();
        GuardPacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> player), (Object)new GuardOpenInventoryPacket(player.containerCounter, this.guardInventory.getContainerSize(), this.getId()));
        player.containerMenu = new GuardContainer(player.containerCounter, player.getInventory(), (Container)this.guardInventory, this);
        player.initMenu(player.containerMenu);
        NeoForge.EVENT_BUS.post((Event)new PlayerContainerEvent.Open((Player)player, player.containerMenu));
    }

    public boolean isEating() {
        return GuardEatFoodGoal.isConsumable(this.getUseItem()) && this.isUsingItem();
    }

    public boolean isPatrolling() {
        return (Boolean)this.entityData.get(PATROLLING);
    }

    public void setPatrolling(boolean patrolling) {
        this.entityData.set(PATROLLING, (Object)patrolling);
    }

    public boolean canFireProjectileWeapon(ProjectileWeaponItem item) {
        return item instanceof BowItem || item instanceof CrossbowItem || super.canFireProjectileWeapon(item);
    }

    public static class GuardData
    implements SpawnGroupData {
        public final int variantData;

        public GuardData(int type) {
            this.variantData = type;
        }
    }

    public static class GuardMeleeGoal
    extends MeleeAttackGoal {
        private static final double DEFAULT_ATTACK_REACH = Math.sqrt(2.04f) - (double)0.6f;
        public final Guard guard;

        public GuardMeleeGoal(Guard guard, double speedIn, boolean useLongMemory) {
            super((PathfinderMob)guard, speedIn, useLongMemory);
            this.guard = guard;
        }

        public boolean canUse() {
            return !this.mob.isHolding(is -> is.getItem() instanceof CrossbowItem) && !this.mob.isHolding(is -> is.getItem() instanceof BowItem) && this.guard.getTarget() != null && !this.guard.isEating() && super.canUse();
        }

        public boolean canContinueToUse() {
            return super.canContinueToUse() && this.guard.getTarget() != null;
        }

        public void tick() {
            LivingEntity target = this.guard.getTarget();
            if (target != null) {
                if ((double)target.distanceTo((Entity)this.guard) <= 3.0 && !this.guard.isBlocking()) {
                    this.guard.getMoveControl().strafe(-2.0f, 0.0f);
                    this.guard.lookAt((Entity)target, 30.0f, 30.0f);
                }
                if (this.path != null && (double)target.distanceTo((Entity)this.guard) <= 2.0) {
                    this.guard.getNavigation().stop();
                }
                super.tick();
            }
        }

        protected void checkAndPerformAttack(LivingEntity enemy) {
            if (this.canPerformAttack(enemy)) {
                this.resetAttackCooldown();
                this.guard.stopUsingItem();
                if (this.guard.shieldCoolDown == 0) {
                    this.guard.shieldCoolDown = 8;
                }
                this.guard.swing(InteractionHand.MAIN_HAND);
                this.guard.doHurtTarget((Entity)enemy);
            }
        }

        protected boolean canPerformAttack(LivingEntity mob) {
            return this.isTimeToAttack() && this.mobHitBox((LivingEntity)this.mob).inflate(0.8).intersects(this.mobHitBox(mob)) && this.mob.getSensing().hasLineOfSight((Entity)mob);
        }

        protected AABB mobHitBox(LivingEntity mob) {
            AABB aabb;
            Entity entity = mob.getVehicle();
            if (entity != null) {
                AABB aabb1 = entity.getBoundingBox();
                AABB aabb2 = mob.getBoundingBox();
                aabb = new AABB(Math.min(aabb2.minX, aabb1.minX), aabb2.minY, Math.min(aabb2.minZ, aabb1.minZ), Math.max(aabb2.maxX, aabb1.maxX), aabb2.maxY, Math.max(aabb2.maxZ, aabb1.maxZ));
            } else {
                aabb = mob.getBoundingBox();
            }
            return aabb.inflate(DEFAULT_ATTACK_REACH, 0.0, DEFAULT_ATTACK_REACH);
        }
    }

    public static class FollowHeroGoal
    extends Goal {
        public final Guard guard;

        public FollowHeroGoal(Guard mob) {
            this.guard = mob;
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public void tick() {
            if (this.guard.getOwner() != null && (double)this.guard.getOwner().distanceTo((Entity)this.guard) > 3.0) {
                this.guard.getNavigation().moveTo((Entity)this.guard.getOwner(), 0.7);
                this.guard.getLookControl().setLookAt((Entity)this.guard.getOwner());
            } else {
                this.guard.getNavigation().stop();
            }
        }

        public boolean canContinueToUse() {
            return this.canUse();
        }

        public boolean canUse() {
            return this.guard.isFollowing() && this.guard.getOwner() != null;
        }

        public void stop() {
            this.guard.getNavigation().stop();
        }
    }

    public static class DefendVillageGuardGoal
    extends TargetGoal {
        private final Guard guard;
        private LivingEntity villageAggressorTarget;

        public DefendVillageGuardGoal(Guard guardIn) {
            super((Mob)guardIn, true, true);
            this.guard = guardIn;
            this.setFlags(EnumSet.of(Goal.Flag.TARGET, Goal.Flag.MOVE));
        }

        public boolean canUse() {
            AABB axisalignedbb = this.guard.getBoundingBox().inflate(10.0, 8.0, 10.0);
            List list = this.guard.level().getEntitiesOfClass(Villager.class, axisalignedbb);
            List list1 = this.guard.level().getEntitiesOfClass(Player.class, axisalignedbb);
            for (Villager villager : list) {
                for (Player player : list1) {
                    int i = villager.getPlayerReputation(player);
                    if (i > (Integer)GuardConfig.COMMON.reputationRequirementToBeAttacked.get()) continue;
                    this.villageAggressorTarget = player;
                    if (this.villageAggressorTarget.getTeam() == null || this.guard.getTeam() == null || !this.guard.getTeam().isAlliedTo(this.villageAggressorTarget.getTeam())) continue;
                    return false;
                }
            }
            return this.villageAggressorTarget != null && !this.villageAggressorTarget.hasEffect(MobEffects.HERO_OF_THE_VILLAGE) && !this.villageAggressorTarget.isSpectator() && !((Player)this.villageAggressorTarget).isCreative();
        }

        public void start() {
            this.guard.setTarget(this.villageAggressorTarget);
            super.start();
        }
    }
}

