/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.entities.ai.goals;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import tallestegg.guardvillagers.entities.Guard;

public class ArmorerRepairGuardArmorGoal
extends Goal {
    private final Guard guard;
    private Villager villager;

    public ArmorerRepairGuardArmorGoal(Guard guard) {
        this.guard = guard;
    }

    public boolean canUse() {
        List list = this.guard.level().getEntitiesOfClass(Villager.class, this.guard.getBoundingBox().inflate(10.0, 3.0, 10.0));
        if (!list.isEmpty()) {
            for (Villager mob : list) {
                ItemStack itemstack;
                int i;
                boolean isArmorerOrWeaponSmith;
                if (mob == null || !(isArmorerOrWeaponSmith = mob.getVillagerData().getProfession() == VillagerProfession.ARMORER || mob.getVillagerData().getProfession() == VillagerProfession.WEAPONSMITH) || this.guard.getTarget() != null) continue;
                if (mob.getVillagerData().getProfession() == VillagerProfession.ARMORER) {
                    for (i = 0; i < this.guard.guardInventory.getContainerSize() - 2; ++i) {
                        itemstack = this.guard.guardInventory.getItem(i);
                        if (!itemstack.isDamaged() || !(itemstack.getItem() instanceof ArmorItem) || itemstack.getDamageValue() < itemstack.getMaxDamage() / 2) continue;
                        this.villager = mob;
                        return true;
                    }
                }
                if (mob.getVillagerData().getProfession() != VillagerProfession.WEAPONSMITH) continue;
                for (i = 4; i < 6; ++i) {
                    itemstack = this.guard.guardInventory.getItem(i);
                    if (!itemstack.isDamaged() || itemstack.getDamageValue() < itemstack.getMaxDamage() / 2) continue;
                    this.villager = mob;
                    return true;
                }
            }
        }
        return false;
    }

    public void tick() {
        this.guard.getLookControl().setLookAt((Entity)this.villager, 30.0f, 30.0f);
        if ((double)this.guard.distanceTo((Entity)this.villager) >= 2.0) {
            this.guard.getNavigation().moveTo((Entity)this.villager, 0.5);
            this.villager.getNavigation().moveTo((Entity)this.guard, 0.5);
        } else {
            ItemStack itemstack;
            int i;
            VillagerProfession profession = this.villager.getVillagerData().getProfession();
            if (profession == VillagerProfession.ARMORER) {
                for (i = 0; i < this.guard.guardInventory.getContainerSize() - 2; ++i) {
                    itemstack = this.guard.guardInventory.getItem(i);
                    if (!itemstack.isDamaged() || !(itemstack.getItem() instanceof ArmorItem) || itemstack.getDamageValue() < itemstack.getMaxDamage() / 2 + this.guard.getRandom().nextInt(5)) continue;
                    itemstack.setDamageValue(itemstack.getDamageValue() - this.guard.getRandom().nextInt(5));
                }
            }
            if (profession == VillagerProfession.WEAPONSMITH) {
                for (i = 4; i < 6; ++i) {
                    itemstack = this.guard.guardInventory.getItem(i);
                    if (!itemstack.isDamaged() || itemstack.getDamageValue() < itemstack.getMaxDamage() / 2 + this.guard.getRandom().nextInt(5)) continue;
                    itemstack.setDamageValue(itemstack.getDamageValue() - this.guard.getRandom().nextInt(5));
                }
            }
        }
    }
}

