/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.entities.ai.goals;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ToolActions;
import tallestegg.guardvillagers.entities.Guard;

public class FollowShieldGuards
extends Goal {
    private static final TargetingConditions NEARBY_GUARDS = TargetingConditions.forNonCombat().range(8.0).ignoreLineOfSight();
    private final Guard taskOwner;
    private Guard guardtofollow;
    private double x;
    private double y;
    private double z;

    public FollowShieldGuards(Guard taskOwnerIn) {
        this.taskOwner = taskOwnerIn;
    }

    public boolean canUse() {
        List list = this.taskOwner.level().getEntitiesOfClass(((Object)((Object)this.taskOwner)).getClass(), this.taskOwner.getBoundingBox().inflate(8.0, 8.0, 8.0));
        if (!list.isEmpty()) {
            for (Guard guard : list) {
                if (guard.isInvisible() || !guard.getOffhandItem().canPerformAction(ToolActions.SHIELD_BLOCK) || !guard.isBlocking() || this.taskOwner.level().getNearbyEntities(Guard.class, NEARBY_GUARDS.range(3.0), (LivingEntity)guard, this.taskOwner.getBoundingBox().inflate(5.0)).size() >= 5) continue;
                this.guardtofollow = guard;
                Vec3 vec3d = this.getPosition();
                if (vec3d == null) {
                    return false;
                }
                this.x = vec3d.x;
                this.y = vec3d.y;
                this.z = vec3d.z;
                return true;
            }
        }
        return false;
    }

    @Nullable
    protected Vec3 getPosition() {
        return DefaultRandomPos.getPosTowards((PathfinderMob)this.taskOwner, (int)16, (int)7, (Vec3)this.guardtofollow.position(), (double)1.5707963705062866);
    }

    public boolean canContinueToUse() {
        return !this.taskOwner.getNavigation().isDone() && !this.taskOwner.isVehicle();
    }

    public void stop() {
        this.taskOwner.getNavigation().stop();
        super.stop();
    }

    public void start() {
        this.taskOwner.getNavigation().moveTo(this.x, this.y, this.z, 0.4);
    }
}

