/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.entities.ai.goals;

import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SplashPotionItem;
import net.minecraft.world.item.UseAnim;
import tallestegg.guardvillagers.entities.Guard;

public class GuardEatFoodGoal
extends Goal {
    public final Guard guard;

    public GuardEatFoodGoal(Guard guard) {
        this.guard = guard;
    }

    public static boolean isConsumable(ItemStack stack) {
        return stack.getUseAnimation() == UseAnim.EAT || stack.getUseAnimation() == UseAnim.DRINK && !(stack.getItem() instanceof SplashPotionItem);
    }

    public boolean canUse() {
        return this.guard.getHealth() < this.guard.getMaxHealth() && GuardEatFoodGoal.isConsumable(this.guard.getOffhandItem()) && this.guard.isEating() || this.guard.getHealth() < this.guard.getMaxHealth() && GuardEatFoodGoal.isConsumable(this.guard.getOffhandItem()) && this.guard.getTarget() == null && !this.guard.isAggressive();
    }

    public boolean canContinueToUse() {
        List list = this.guard.level().getEntitiesOfClass(LivingEntity.class, this.guard.getBoundingBox().inflate(5.0, 3.0, 5.0));
        if (!list.isEmpty()) {
            for (LivingEntity mob : list) {
                if (mob == null || !(mob instanceof Mob) || !(((Mob)mob).getTarget() instanceof Guard)) continue;
                return false;
            }
        }
        return this.guard.isUsingItem() && this.guard.getTarget() == null && this.guard.getHealth() < this.guard.getMaxHealth() || this.guard.getTarget() != null && this.guard.getHealth() < this.guard.getMaxHealth() / 2.0f + 2.0f && this.guard.isEating();
    }

    public void start() {
        this.guard.startUsingItem(InteractionHand.OFF_HAND);
    }
}

