/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.entities.ai.goals;

import java.util.List;
import net.minecraft.core.Position;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import tallestegg.guardvillagers.entities.Guard;

public class GuardInteractDoorGoal
extends OpenDoorGoal {
    private Guard guard;

    public GuardInteractDoorGoal(Guard pMob, boolean pCloseDoor) {
        super((Mob)pMob, pCloseDoor);
        this.guard = pMob;
    }

    public boolean canUse() {
        return super.canUse();
    }

    public void start() {
        if (this.areOtherMobsComingThroughDoor(this.guard)) {
            super.start();
            this.guard.swing(InteractionHand.MAIN_HAND);
        }
    }

    private boolean areOtherMobsComingThroughDoor(Guard pEntity) {
        List nearbyEntityList = pEntity.level().getEntitiesOfClass(PathfinderMob.class, pEntity.getBoundingBox().inflate(4.0));
        if (!nearbyEntityList.isEmpty()) {
            for (PathfinderMob mob : nearbyEntityList) {
                if (!mob.blockPosition().closerToCenterThan((Position)pEntity.position(), 2.0)) continue;
                return this.isMobComingThroughDoor(mob);
            }
        }
        return false;
    }

    private boolean isMobComingThroughDoor(PathfinderMob pEntity) {
        if (pEntity.getNavigation() == null) {
            return false;
        }
        Path path = pEntity.getNavigation().getPath();
        if (path == null || path.isDone()) {
            return false;
        }
        Node node = path.getPreviousNode();
        if (node == null) {
            return false;
        }
        Node node1 = path.getNextNode();
        return pEntity.blockPosition().equals((Object)node.asBlockPos()) || pEntity.blockPosition().equals((Object)node1.asBlockPos());
    }
}

