/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.entities.ai.goals;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.npc.Villager;
import tallestegg.guardvillagers.entities.Guard;

public class GuardLookAtAndStopMovingWhenBeingTheInteractionTarget
extends Goal {
    private final Guard guard;
    private Villager villager;

    public GuardLookAtAndStopMovingWhenBeingTheInteractionTarget(Guard guard) {
        this.guard = guard;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        List list = this.guard.level().getEntitiesOfClass(Villager.class, this.guard.getBoundingBox().inflate(10.0));
        if (!list.isEmpty()) {
            for (Villager villager : list) {
                if (!villager.getBrain().hasMemoryValue(MemoryModuleType.INTERACTION_TARGET) || !((LivingEntity)villager.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET).get()).is((Entity)this.guard)) continue;
                this.villager = villager;
                return true;
            }
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.canUse();
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        super.tick();
        this.guard.getNavigation().stop();
        this.guard.lookAt((Entity)this.villager, 30.0f, 30.0f);
        this.guard.getLookControl().setLookAt((Entity)this.villager);
    }
}

