/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.entities.ai.goals;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;
import tallestegg.guardvillagers.entities.Guard;
import tallestegg.guardvillagers.entities.ai.goals.GuardEatFoodGoal;

public class GuardRunToEatGoal
extends RandomStrollGoal {
    private final Guard guard;
    private int walkTimer;

    public GuardRunToEatGoal(Guard guard) {
        super((PathfinderMob)guard, 1.0);
        this.guard = guard;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.TARGET, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return this.guard.getHealth() < this.guard.getMaxHealth() / 2.0f && GuardEatFoodGoal.isConsumable(this.guard.getOffhandItem()) && !this.guard.isEating() && this.guard.getTarget() != null && this.getPosition() != null;
    }

    public void start() {
        super.start();
        this.guard.setTarget(null);
        if (this.walkTimer <= 0) {
            this.walkTimer = 20;
        }
    }

    public void tick() {
        --this.walkTimer;
        List list = this.guard.level().getEntitiesOfClass(LivingEntity.class, this.guard.getBoundingBox().inflate(5.0, 3.0, 5.0));
        if (!list.isEmpty()) {
            for (LivingEntity mob : list) {
                if (mob == null || !(mob.getLastHurtMob() instanceof Guard) && (!(mob instanceof Mob) || !(((Mob)mob).getTarget() instanceof Guard)) || this.walkTimer >= 20) continue;
                this.walkTimer += 5;
            }
        }
    }

    protected Vec3 getPosition() {
        List list = this.guard.level().getEntitiesOfClass(LivingEntity.class, this.guard.getBoundingBox().inflate(5.0, 3.0, 5.0));
        if (!list.isEmpty()) {
            for (LivingEntity mob : list) {
                if (mob == null || !(mob.getLastHurtMob() instanceof Guard) && (!(mob instanceof Mob) || !(((Mob)mob).getTarget() instanceof Guard))) continue;
                return DefaultRandomPos.getPosAway((PathfinderMob)this.guard, (int)16, (int)7, (Vec3)mob.position());
            }
        }
        return super.getPosition();
    }

    public boolean canContinueToUse() {
        return super.canContinueToUse() && this.walkTimer > 0 && !this.guard.isEating();
    }

    public void stop() {
        super.stop();
        this.guard.startUsingItem(InteractionHand.OFF_HAND);
        this.guard.getNavigation().stop();
    }
}

