/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.entities.ai.goals;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.ToolActions;
import tallestegg.guardvillagers.configuration.GuardConfig;
import tallestegg.guardvillagers.entities.Guard;

public class RaiseShieldGoal
extends Goal {
    public final Guard guard;

    public RaiseShieldGoal(Guard guard) {
        this.guard = guard;
    }

    public boolean canUse() {
        return !CrossbowItem.isCharged((ItemStack)this.guard.getMainHandItem()) && this.guard.getOffhandItem().getItem().canPerformAction(this.guard.getOffhandItem(), ToolActions.SHIELD_BLOCK) && this.raiseShield() && this.guard.shieldCoolDown == 0 && !this.guard.getOffhandItem().getItem().equals(Registries.ITEM.registry().equals((Object)new ResourceLocation("bigbrain:buckler")));
    }

    public boolean canContinueToUse() {
        return this.canUse();
    }

    public void start() {
        if (this.guard.getOffhandItem().getItem().canPerformAction(this.guard.getOffhandItem(), ToolActions.SHIELD_BLOCK)) {
            this.guard.startUsingItem(InteractionHand.OFF_HAND);
        }
    }

    public void stop() {
        if (!GuardConfig.GuardAlwaysShield) {
            this.guard.stopUsingItem();
        }
    }

    protected boolean raiseShield() {
        LivingEntity target = this.guard.getTarget();
        if (target != null && this.guard.shieldCoolDown == 0) {
            boolean ranged;
            boolean bl = ranged = this.guard.getMainHandItem().getItem() instanceof CrossbowItem || this.guard.getMainHandItem().getItem() instanceof BowItem;
            return (double)this.guard.distanceTo((Entity)target) <= 4.0 || target instanceof Creeper || target instanceof RangedAttackMob && (double)target.distanceTo((Entity)this.guard) >= 5.0 && !ranged || target instanceof Ravager || GuardConfig.GuardAlwaysShield;
        }
        return false;
    }
}

