/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.entities.ai.goals;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.npc.Villager;
import tallestegg.guardvillagers.entities.Guard;

public class VillagerGossipToGuardGoal
extends Goal {
    protected final Villager villager;
    protected Guard guard;

    public VillagerGossipToGuardGoal(Villager villager) {
        this.villager = villager;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        Object t;
        if (this.villager.getBrain().hasMemoryValue(MemoryModuleType.INTERACTION_TARGET) && (t = this.villager.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET).get()) instanceof Guard) {
            Guard guard;
            this.guard = guard = (Guard)((Object)t);
            long gameTime = guard.level().getGameTime();
            if (!(this.nearbyVillagersInteractingWithGuards() || gameTime >= this.guard.lastGossipTime && gameTime < this.guard.lastGossipTime + 1200L)) {
                return this.guard.getTarget() == null && !this.villager.level().isNight();
            }
        }
        return false;
    }

    public boolean canContinueToUse() {
        return !this.nearbyVillagersInteractingWithGuards() && this.guard.getTarget() == null && this.villager.getBrain().hasMemoryValue(MemoryModuleType.INTERACTION_TARGET) && ((LivingEntity)this.villager.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET).get()).is((Entity)this.guard);
    }

    public void start() {
        this.villager.getBrain().setMemory(MemoryModuleType.INTERACTION_TARGET, (Object)this.guard);
    }

    public void tick() {
        this.villager.getBrain().setMemory(MemoryModuleType.INTERACTION_TARGET, (Object)this.guard);
        if (!this.nearbyVillagersInteractingWithGuards() && this.villager.getBrain().hasMemoryValue(MemoryModuleType.INTERACTION_TARGET) && ((LivingEntity)this.villager.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET).get()).is((Entity)this.guard)) {
            BehaviorUtils.lookAtEntity((LivingEntity)this.villager, (LivingEntity)this.guard);
            if ((double)this.villager.distanceTo((Entity)this.guard) > 2.0) {
                this.villager.getNavigation().moveTo((Entity)this.guard, 0.5);
            } else {
                this.villager.getNavigation().stop();
                this.guard.gossip(this.villager, this.guard.level().getGameTime());
            }
            this.villager.lookAt((Entity)this.guard, 30.0f, 30.0f);
            this.villager.getLookControl().setLookAt((Entity)this.guard, 30.0f, 30.0f);
        }
    }

    public void stop() {
        this.villager.getBrain().eraseMemory(MemoryModuleType.INTERACTION_TARGET);
    }

    private boolean nearbyVillagersInteractingWithGuards() {
        if (this.villager.getBrain().hasMemoryValue(MemoryModuleType.NEAREST_LIVING_ENTITIES)) {
            Optional list = this.villager.getBrain().getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES);
            for (LivingEntity entity : (List)list.get()) {
                Villager nearbyVillager;
                if (!(entity instanceof Villager) || !(nearbyVillager = (Villager)entity).getBrain().hasMemoryValue(MemoryModuleType.INTERACTION_TARGET)) continue;
                return nearbyVillager.getBrain().hasMemoryValue(MemoryModuleType.INTERACTION_TARGET) && ((LivingEntity)nearbyVillager.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET).get()).is((Entity)this.guard);
            }
        }
        return false;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }
}

