/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.entities.ai.goals;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.phys.Vec3;
import tallestegg.guardvillagers.entities.Guard;

public class WalkBackToCheckPointGoal
extends Goal {
    private final Guard guard;
    private final double speed;

    public WalkBackToCheckPointGoal(Guard guard, double speedIn) {
        this.guard = guard;
        this.speed = speedIn;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean canUse() {
        return this.guard.getPatrolPos() != null && !this.guard.getPatrolPos().closerThan((Vec3i)this.guard.blockPosition(), 1.0) && !this.guard.isFollowing() && this.guard.isPatrolling();
    }

    public boolean canContinueToUse() {
        return this.canUse();
    }

    public void tick() {
        BlockPos blockpos = this.guard.getPatrolPos();
        if (blockpos != null) {
            Vec3 vector3d = Vec3.atBottomCenterOf((Vec3i)blockpos);
            Vec3 vector3d1 = DefaultRandomPos.getPosTowards((PathfinderMob)this.guard, (int)16, (int)3, (Vec3)vector3d, (double)0.3141592741012573);
            if (!this.guard.getPatrolPos().closerThan((Vec3i)this.guard.blockPosition(), 1.0) || blockpos != null) {
                if (this.guard.getMainHandItem().getItem() instanceof ProjectileWeaponItem) {
                    this.guard.getNavigation().moveTo((double)blockpos.getX(), (double)blockpos.getY(), (double)blockpos.getZ(), this.speed);
                } else if (vector3d1 != null && this.guard.getTarget() == null) {
                    this.guard.getNavigation().moveTo(vector3d1.x(), vector3d1.y(), vector3d1.z(), this.speed);
                }
            }
        }
    }
}

