/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.entities.ai.tasks;

import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.behavior.WorkAtPoi;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class RepairGolemTask
extends WorkAtPoi {
    private IronGolem golem;
    private boolean hasStartedHealing;

    protected boolean checkExtraStartConditions(ServerLevel worldIn, Villager owner) {
        List list = owner.level().getEntitiesOfClass(IronGolem.class, owner.getBoundingBox().inflate(10.0, 5.0, 10.0));
        if (!list.isEmpty()) {
            for (IronGolem golem : list) {
                if (golem.isInvisible() || !golem.isAlive() || golem.getType() != EntityType.IRON_GOLEM || !((double)golem.getHealth() <= 60.0) && (!this.hasStartedHealing || !(golem.getHealth() < golem.getMaxHealth()))) continue;
                this.golem = golem;
                owner.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.IRON_INGOT));
                return true;
            }
        }
        return false;
    }

    protected void stop(ServerLevel worldIn, Villager entityIn, long gameTimeIn) {
        if (this.golem.getHealth() == this.golem.getMaxHealth()) {
            this.hasStartedHealing = false;
            entityIn.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        }
    }

    protected void start(ServerLevel worldIn, Villager entityIn, long gameTimeIn) {
        if (this.golem == null) {
            return;
        }
        entityIn.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.IRON_INGOT));
        this.healGolem(entityIn);
    }

    protected void tick(ServerLevel worldIn, Villager entityIn, long gameTimeIn) {
        if (this.golem.getHealth() < this.golem.getMaxHealth()) {
            this.healGolem(entityIn);
        }
    }

    public void healGolem(Villager healer) {
        healer.getNavigation().moveTo((Entity)this.golem, 0.5);
        if ((double)healer.distanceTo((Entity)this.golem) <= 2.0) {
            this.hasStartedHealing = true;
            healer.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.IRON_INGOT));
            healer.swing(InteractionHand.MAIN_HAND);
            this.golem.heal(15.0f);
            float pitch = 1.0f + (this.golem.getRandom().nextFloat() - this.golem.getRandom().nextFloat()) * 0.2f;
            this.golem.playSound(SoundEvents.IRON_GOLEM_REPAIR, 1.0f, pitch);
        }
    }
}

