/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.entities.ai.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import tallestegg.guardvillagers.GuardEntityType;
import tallestegg.guardvillagers.entities.Guard;

public class ShareGossipWithGuard
extends Behavior<Villager> {
    public ShareGossipWithGuard() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.INTERACTION_TARGET, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryStatus.VALUE_PRESENT));
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, Villager pOwner) {
        return BehaviorUtils.targetIsValid((Brain)pOwner.getBrain(), (MemoryModuleType)MemoryModuleType.INTERACTION_TARGET, (EntityType)((EntityType)GuardEntityType.GUARD.get()));
    }

    protected boolean canStillUse(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        return this.checkExtraStartConditions(pLevel, pEntity);
    }

    protected void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        Guard guard = (Guard)((Object)pEntity.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET).get());
        BehaviorUtils.lockGazeAndWalkToEachOther((LivingEntity)pEntity, (LivingEntity)guard, (float)0.5f);
    }

    protected void tick(ServerLevel pLevel, Villager pOwner, long pGameTime) {
        Guard guard = (Guard)((Object)pOwner.getBrain().getMemory(MemoryModuleType.INTERACTION_TARGET).get());
        if (pOwner.distanceToSqr((Entity)guard) < 5.0) {
            BehaviorUtils.lockGazeAndWalkToEachOther((LivingEntity)pOwner, (LivingEntity)guard, (float)0.5f);
            guard.gossip(pOwner, pGameTime);
        }
        if (pOwner.hasExcessFood() && guard.getOffhandItem().isEmpty()) {
            ShareGossipWithGuard.throwHalfStack(pOwner, Villager.FOOD_POINTS.keySet(), (LivingEntity)guard);
        }
    }

    protected void stop(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        pEntity.getBrain().eraseMemory(MemoryModuleType.INTERACTION_TARGET);
    }

    private static void throwHalfStack(Villager pVillager, Set<Item> pStack, LivingEntity pEntity) {
        SimpleContainer simplecontainer = pVillager.getInventory();
        ItemStack itemstack = ItemStack.EMPTY;
        for (int i = 0; i < simplecontainer.getContainerSize(); ++i) {
            int j;
            Item item;
            ItemStack itemstack1 = simplecontainer.getItem(i);
            if (itemstack1.isEmpty() || !pStack.contains(item = itemstack1.getItem())) continue;
            if (itemstack1.getCount() > itemstack1.getMaxStackSize() / 2) {
                j = itemstack1.getCount() / 2;
            } else {
                if (itemstack1.getCount() <= 24) continue;
                j = itemstack1.getCount() - 24;
            }
            itemstack1.shrink(j);
            itemstack = new ItemStack((ItemLike)item, j);
            break;
        }
        if (!itemstack.isEmpty()) {
            pEntity.setItemSlot(EquipmentSlot.OFFHAND, itemstack);
        }
    }
}

