/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.networking;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.neoforged.neoforge.network.NetworkEvent;
import tallestegg.guardvillagers.entities.Guard;

public class GuardFollowPacket {
    private final int entityId;

    public GuardFollowPacket(int entityId) {
        this.entityId = entityId;
    }

    public static GuardFollowPacket decode(FriendlyByteBuf buf) {
        return new GuardFollowPacket(buf.readInt());
    }

    public static void encode(GuardFollowPacket msg, FriendlyByteBuf buf) {
        buf.writeInt(msg.entityId);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public void handle(final NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> ctx.enqueueWork(new Runnable(){

            @Override
            public void run() {
                Entity entity;
                ServerPlayer player = ctx.getSender();
                if (player != null && player.level() instanceof ServerLevel && (entity = player.level().getEntity(GuardFollowPacket.this.getEntityId())) instanceof Guard) {
                    Guard guard;
                    guard.setFollowing(!(guard = (Guard)entity).isFollowing());
                    guard.setOwnerId(player.getUUID());
                    guard.playSound(SoundEvents.VILLAGER_YES, 1.0f, 1.0f);
                }
            }
        }));
        ctx.setPacketHandled(true);
    }
}

