/*
 * Decompiled with CFR 0.152.
 */
package com.hostilevillages;

import com.google.common.collect.ImmutableList;
import com.hostilevillages.RandomVillageDataSet;
import com.hostilevillages.command.CommandFindPersistent;
import com.hostilevillages.config.Configuration;
import com.hostilevillages.event.EventHandler;
import com.hostilevillages.event.ModEventHandler;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.world.level.levelgen.feature.structures.StructurePoolElement;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.IExtensionPoint;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fmlserverevents.FMLServerAboutToStartEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="hostilevillages")
public class HostileVillages {
    public static final String MODID = "hostilevillages";
    public static final Random rand = new Random();
    public static final Logger LOGGER = LogManager.getLogger();
    public static Configuration config = new Configuration();
    private static Map<ResourceLocation, StructureTemplatePool> patterns = new HashMap<ResourceLocation, StructureTemplatePool>();

    public HostileVillages() {
        ModLoadingContext.get().registerExtensionPoint(IExtensionPoint.DisplayTest.class, () -> new IExtensionPoint.DisplayTest(() -> "", (c, b) -> true));
        ((IEventBus)Mod.EventBusSubscriber.Bus.MOD.bus().get()).register(ModEventHandler.class);
        ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).register(EventHandler.class);
        ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).addListener(this::serverStart);
        ((IEventBus)Mod.EventBusSubscriber.Bus.FORGE.bus().get()).addListener(this::onCommandsRegister);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
    }

    private void setup(FMLCommonSetupEvent event) {
        RandomVillageDataSet.parseFromConfig();
        LOGGER.info("Hostile Villages initialized");
    }

    public void onCommandsRegister(RegisterCommandsEvent event) {
        LiteralArgumentBuilder root = LiteralArgumentBuilder.literal((String)MODID);
        event.getDispatcher().register((LiteralArgumentBuilder)root.then(new CommandFindPersistent().build()));
    }

    private void serverStart(FMLServerAboutToStartEvent event) {
        for (String name : Arrays.asList("plains", "savanna", "snowy", "taiga", "desert")) {
            List list = ((StructureTemplatePool)((Registry)event.getServer().m_129911_().m_6632_((ResourceKey)Registry.f_122884_).get()).m_7745_((ResourceLocation)new ResourceLocation((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"minecraft:village/\u0001/zombie/houses"}, (String)name))))).f_69250_;
            for (String structure : (List)HostileVillages.config.getCommonConfig().additionalStructures.get()) {
                for (int i = 0; i < (Integer)HostileVillages.config.getCommonConfig().additionalStructuresWeight.get(); ++i) {
                    list.add((StructurePoolElement)StructurePoolElement.m_69192_((String)structure).apply(StructureTemplatePool.Projection.RIGID));
                }
            }
        }
    }

    public static StructureTemplatePool getReplacement(StructureTemplatePool pattern) {
        if (patterns.containsKey(pattern.m_69275_())) {
            return patterns.get(pattern.m_69275_());
        }
        return null;
    }

    public static ImmutableList<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>> newListOf(Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer> ... args) {
        ArrayList<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>> list = new ArrayList<Pair<Function<StructureTemplatePool.Projection, ? extends StructurePoolElement>, Integer>>(Arrays.asList(args));
        list.removeIf(element -> (Integer)element.getSecond() <= 0);
        return ImmutableList.copyOf(list);
    }

    public static <T> Codec<Tag<T>> tagCodec(Supplier<TagCollection<T>> iTagCollection) {
        return ResourceLocation.f_135803_.flatXmap(p_232949_1_ -> Optional.ofNullable(((TagCollection)iTagCollection.get()).m_13404_(p_232949_1_)).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown tag: " + p_232949_1_))), tag -> {
            ResourceLocation id = ((TagCollection)iTagCollection.get()).m_7473_(tag);
            if (id == null) {
                Collection tags = ((TagCollection)iTagCollection.get()).m_13394_(tag.m_6497_().get(0));
                for (ResourceLocation currentID : tags) {
                    Tag compare = ((TagCollection)iTagCollection.get()).m_13404_(currentID);
                    if (compare == null || !compare.m_6497_().equals(tag.m_6497_())) continue;
                    id = currentID;
                    break;
                }
            }
            return Optional.ofNullable(id).map(DataResult::success).orElseGet(() -> DataResult.error((String)("Unknown tag: " + tag)));
        });
    }

    static {
        int villageChance = (Integer)HostileVillages.config.getCommonConfig().vanillaVillageChance.get();
        int zombieChance = 100 - villageChance;
        int villageMin = villageChance > 0 ? 1 : 0;
        StructureTemplatePool plains = new StructureTemplatePool(new ResourceLocation("village/plains/town_centers"), new ResourceLocation("empty"), HostileVillages.newListOf(Pair.of((Object)StructurePoolElement.m_69197_((String)"village/plains/town_centers/plains_fountain_01", (StructureProcessorList)ProcessorLists.f_127205_), (Object)Math.max(villageMin, villageChance / 4)), Pair.of((Object)StructurePoolElement.m_69197_((String)"village/plains/town_centers/plains_meeting_point_1", (StructureProcessorList)ProcessorLists.f_127205_), (Object)Math.max(villageMin, villageChance / 4)), Pair.of((Object)StructurePoolElement.m_69192_((String)"village/plains/town_centers/plains_meeting_point_2"), (Object)Math.max(villageMin, villageChance / 4)), Pair.of((Object)StructurePoolElement.m_69197_((String)"village/plains/town_centers/plains_meeting_point_3", (StructureProcessorList)ProcessorLists.f_127206_), (Object)Math.max(villageMin, villageChance / 4)), Pair.of((Object)StructurePoolElement.m_69197_((String)"village/plains/zombie/town_centers/plains_fountain_01", (StructureProcessorList)ProcessorLists.f_127199_), (Object)Math.max(1, zombieChance / 4)), Pair.of((Object)StructurePoolElement.m_69197_((String)"village/plains/zombie/town_centers/plains_meeting_point_1", (StructureProcessorList)ProcessorLists.f_127199_), (Object)Math.max(1, zombieChance / 4)), Pair.of((Object)StructurePoolElement.m_69197_((String)"village/plains/zombie/town_centers/plains_meeting_point_2", (StructureProcessorList)ProcessorLists.f_127199_), (Object)Math.max(1, zombieChance / 4)), Pair.of((Object)StructurePoolElement.m_69197_((String)"village/plains/zombie/town_centers/plains_meeting_point_3", (StructureProcessorList)ProcessorLists.f_127199_), (Object)Math.max(1, zombieChance / 4))), StructureTemplatePool.Projection.RIGID);
        StructureTemplatePool snowy = new StructureTemplatePool(new ResourceLocation("village/snowy/town_centers"), new ResourceLocation("empty"), HostileVillages.newListOf(Pair.of((Object)StructurePoolElement.m_69192_((String)"village/snowy/town_centers/snowy_meeting_point_1"), (Object)Math.max(villageMin, villageChance / 3)), Pair.of((Object)StructurePoolElement.m_69192_((String)"village/snowy/town_centers/snowy_meeting_point_2"), (Object)Math.max(villageMin, villageChance / 6)), Pair.of((Object)StructurePoolElement.m_69192_((String)"village/snowy/town_centers/snowy_meeting_point_3"), (Object)Math.max(villageMin, villageChance / 2)), Pair.of((Object)StructurePoolElement.m_69192_((String)"village/snowy/zombie/town_centers/snowy_meeting_point_1"), (Object)Math.max(1, zombieChance / 3)), Pair.of((Object)StructurePoolElement.m_69192_((String)"village/snowy/zombie/town_centers/snowy_meeting_point_2"), (Object)Math.max(1, zombieChance / 6)), Pair.of((Object)StructurePoolElement.m_69192_((String)"village/snowy/zombie/town_centers/snowy_meeting_point_3"), (Object)Math.max(1, zombieChance / 2))), StructureTemplatePool.Projection.RIGID);
        StructureTemplatePool savanna = new StructureTemplatePool(new ResourceLocation("village/savanna/town_centers"), new ResourceLocation("empty"), HostileVillages.newListOf(Pair.of((Object)StructurePoolElement.m_69192_((String)"village/savanna/town_centers/savanna_meeting_point_1"), (Object)((int)Math.max((double)villageMin, (double)villageChance / 4.5))), Pair.of((Object)StructurePoolElement.m_69192_((String)"village/savanna/town_centers/savanna_meeting_point_2"), (Object)Math.max(villageMin, villageChance / 9)), Pair.of((Object)StructurePoolElement.m_69192_((String)"village/savanna/town_centers/savanna_meeting_point_3"), (Object)Math.max(villageMin, villageChance / 3)), Pair.of((Object)StructurePoolElement.m_69192_((String)"village/savanna/town_centers/savanna_meeting_point_4"), (Object)Math.max(villageMin, villageChance / 3)), Pair.of((Object)StructurePoolElement.m_69197_((String)"village/savanna/zombie/town_centers/savanna_meeting_point_1", (StructureProcessorList)ProcessorLists.f_127200_), (Object)Math.max(1, (int)((double)zombieChance / 4.5))), Pair.of((Object)StructurePoolElement.m_69197_((String)"village/savanna/zombie/town_centers/savanna_meeting_point_2", (StructureProcessorList)ProcessorLists.f_127200_), (Object)Math.max(1, zombieChance / 9)), Pair.of((Object)StructurePoolElement.m_69197_((String)"village/savanna/zombie/town_centers/savanna_meeting_point_3", (StructureProcessorList)ProcessorLists.f_127200_), (Object)Math.max(1, zombieChance / 3)), Pair.of((Object)StructurePoolElement.m_69197_((String)"village/savanna/zombie/town_centers/savanna_meeting_point_4", (StructureProcessorList)ProcessorLists.f_127200_), (Object)Math.max(1, zombieChance / 3))), StructureTemplatePool.Projection.RIGID);
        StructureTemplatePool desert = new StructureTemplatePool(new ResourceLocation("village/desert/town_centers"), new ResourceLocation("empty"), HostileVillages.newListOf(Pair.of((Object)StructurePoolElement.m_69192_((String)"village/desert/town_centers/desert_meeting_point_1"), (Object)((int)Math.max((double)villageMin, (double)villageChance / 2.5))), Pair.of((Object)StructurePoolElement.m_69192_((String)"village/desert/town_centers/desert_meeting_point_2"), (Object)((int)Math.max((double)villageMin, (double)villageChance / 2.5))), Pair.of((Object)StructurePoolElement.m_69192_((String)"village/desert/town_centers/desert_meeting_point_3"), (Object)Math.max(villageMin, villageChance / 5)), Pair.of((Object)StructurePoolElement.m_69197_((String)"village/desert/zombie/town_centers/desert_meeting_point_1", (StructureProcessorList)ProcessorLists.f_127203_), (Object)Math.max(1, (int)((double)zombieChance / 2.5))), Pair.of((Object)StructurePoolElement.m_69197_((String)"village/desert/zombie/town_centers/desert_meeting_point_2", (StructureProcessorList)ProcessorLists.f_127203_), (Object)Math.max(1, (int)((double)zombieChance / 2.5))), Pair.of((Object)StructurePoolElement.m_69197_((String)"village/desert/zombie/town_centers/desert_meeting_point_3", (StructureProcessorList)ProcessorLists.f_127203_), (Object)Math.max(1, zombieChance / 5))), StructureTemplatePool.Projection.RIGID);
        StructureTemplatePool taiga = new StructureTemplatePool(new ResourceLocation("village/taiga/town_centers"), new ResourceLocation("empty"), HostileVillages.newListOf(Pair.of((Object)StructurePoolElement.m_69197_((String)"village/taiga/town_centers/taiga_meeting_point_1", (StructureProcessorList)ProcessorLists.f_127204_), (Object)Math.max(villageMin, villageChance / 2)), Pair.of((Object)StructurePoolElement.m_69197_((String)"village/taiga/town_centers/taiga_meeting_point_2", (StructureProcessorList)ProcessorLists.f_127204_), (Object)Math.max(villageMin, villageChance / 2)), Pair.of((Object)StructurePoolElement.m_69197_((String)"village/taiga/zombie/town_centers/taiga_meeting_point_1", (StructureProcessorList)ProcessorLists.f_127202_), (Object)Math.max(1, zombieChance / 2)), Pair.of((Object)StructurePoolElement.m_69197_((String)"village/taiga/zombie/town_centers/taiga_meeting_point_2", (StructureProcessorList)ProcessorLists.f_127202_), (Object)Math.max(1, zombieChance / 2))), StructureTemplatePool.Projection.RIGID);
        patterns.put(plains.m_69275_(), plains);
        patterns.put(snowy.m_69275_(), snowy);
        patterns.put(savanna.m_69275_(), savanna);
        patterns.put(desert.m_69275_(), desert);
        patterns.put(taiga.m_69275_(), taiga);
    }
}

