/*
 * Decompiled with CFR 0.152.
 */
package com.hostilevillages;

import com.hostilevillages.HostileVillages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.registries.ForgeRegistries;

public class RandomVillageDataSet {
    public static List<DataEntry> possibleMonsters = new ArrayList<DataEntry>();
    public static int totalWeight;
    public static List<ResourceLocation> loottables;
    private DataEntry entry;
    private ItemStack mendingArmor;
    private int spawnedEntities = 0;
    private long worldTimeStart = 0L;

    public RandomVillageDataSet() {
        int chosen = HostileVillages.rand.nextInt(totalWeight);
        int currentWeight = 0;
        for (DataEntry entry : possibleMonsters) {
            if (chosen < entry.weight + currentWeight) {
                this.entry = entry;
                break;
            }
            currentWeight += entry.weight;
        }
        if (this.entry == null) {
            this.entry = possibleMonsters.get(0);
        }
        this.mendingArmor = new ItemStack((ItemLike)Items.f_42469_);
        EnchantmentHelper.m_44865_(Collections.singletonMap(Enchantments.f_44962_, 1), (ItemStack)this.mendingArmor);
    }

    public EntityType getEntityReplacement() {
        return HostileVillages.rand.nextInt(this.entry.secondaryChance) > 0 ? this.entry.main : this.entry.secondary;
    }

    public void onEntitySpawn(Mob entity, ServerLevelAccessor world) {
        ++this.spawnedEntities;
        if (entity.m_6336_() == MobType.f_21641_ && entity.m_21532_()) {
            entity.m_8061_(EquipmentSlot.HEAD, Items.f_42407_.m_7968_());
        }
        entity.m_6518_(world, world.m_6436_(entity.m_142538_()), MobSpawnType.STRUCTURE, null, null);
        entity.f_21345_.m_25352_(0, (Goal)new BreakDoorGoal(entity, difficulty -> true));
        if (GoalUtils.m_26894_((Mob)entity)) {
            ((GroundPathNavigation)entity.m_21573_()).m_26477_(true);
        }
        if (!((Boolean)HostileVillages.config.getCommonConfig().generateLoot.get()).booleanValue()) {
            return;
        }
        if (entity.m_21532_() && this.spawnedEntities > 12 && this.mendingArmor != null && (entity.m_6336_() == MobType.f_21641_ || entity.m_6336_() == MobType.f_21643_)) {
            entity.m_8061_(EquipmentSlot.CHEST, this.mendingArmor);
            entity.m_21508_(EquipmentSlot.CHEST);
            this.mendingArmor = null;
        }
        if (entity.m_21532_() && this.spawnedEntities > 12 && HostileVillages.rand.nextInt(20) == 0) {
            MinecartChest en = (MinecartChest)EntityType.f_20470_.m_20615_((Level)world.m_6018_());
            en.m_6034_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            world.m_7967_((Entity)en);
            en.m_38236_(loottables.get(HostileVillages.rand.nextInt(loottables.size())), (long)HostileVillages.rand.nextInt(509));
            if (((Boolean)HostileVillages.config.getCommonConfig().allowVanillaVillagerSpawn.get()).booleanValue()) {
                for (int i = 0; i < 27; ++i) {
                    if (en.m_8020_(i).m_41720_() != Items.f_41852_) continue;
                    en.m_6836_(i, Items.f_42601_.m_7968_());
                    break;
                }
            }
        }
    }

    public boolean isValid(Level world) {
        return world.m_46467_() - this.worldTimeStart < 2400L;
    }

    public void setWorldTimeStart(long worldTimeStart) {
        this.worldTimeStart = worldTimeStart;
    }

    public static void parseFromConfig() {
        totalWeight = 0;
        possibleMonsters = new ArrayList<DataEntry>();
        loottables = new ArrayList<ResourceLocation>();
        for (String entry : (List)HostileVillages.config.getCommonConfig().villageEntityTypes.get()) {
            int weight;
            int secondaryChance;
            String[] splitEntry = entry.split(";");
            if (splitEntry.length != 4) {
                HostileVillages.LOGGER.error("Config entry could not be parsed, wrong amount of parameters: " + entry);
                continue;
            }
            ResourceLocation main = ResourceLocation.m_135820_((String)splitEntry[0]);
            if (main == null) {
                HostileVillages.LOGGER.error("Config entry could not be parsed, not a valid resource location " + splitEntry[0]);
                continue;
            }
            EntityType mainType = (EntityType)ForgeRegistries.ENTITIES.getValue(main);
            if (mainType == null) {
                HostileVillages.LOGGER.error("Config entry could not be parsed, not a valid entity type" + splitEntry[0]);
                continue;
            }
            ResourceLocation secondary = ResourceLocation.m_135820_((String)splitEntry[1]);
            if (secondary == null) {
                HostileVillages.LOGGER.error("Config entry could not be parsed, not a valid resource location " + splitEntry[1]);
                continue;
            }
            EntityType secondaryType = (EntityType)ForgeRegistries.ENTITIES.getValue(secondary);
            if (secondaryType == null) {
                HostileVillages.LOGGER.error("Config entry could not be parsed, not a valid entity type" + splitEntry[1]);
                continue;
            }
            try {
                secondaryChance = Integer.parseInt(splitEntry[2]);
                weight = Integer.parseInt(splitEntry[3]);
            }
            catch (Exception e) {
                HostileVillages.LOGGER.error("Config entry could not be parsed, not a number" + splitEntry[2] + splitEntry[3]);
                continue;
            }
            totalWeight += weight;
            possibleMonsters.add(new DataEntry(mainType, secondaryType, secondaryChance, weight));
        }
        for (String entry : (List)HostileVillages.config.getCommonConfig().loottables.get()) {
            ResourceLocation lootID = ResourceLocation.m_135820_((String)entry);
            if (lootID == null) {
                HostileVillages.LOGGER.error("Config entry could not be parsed, not a valid resource location " + entry);
                continue;
            }
            loottables.add(lootID);
        }
    }

    static {
        loottables = new ArrayList<ResourceLocation>();
    }

    static class DataEntry {
        final EntityType main;
        final EntityType secondary;
        final int weight;
        final int secondaryChance;

        private DataEntry(EntityType main, EntityType secondary, int secondaryChance, int weight) {
            this.main = main;
            this.secondary = secondary;
            this.secondaryChance = secondaryChance;
            this.weight = weight;
        }
    }
}

