/*
 * Decompiled with CFR 0.152.
 */
package com.hostilevillages.command;

import com.hostilevillages.command.IMCCommand;
import com.hostilevillages.command.IMCOPCommand;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.MinecartChest;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class CommandFindPersistent
implements IMCOPCommand {
    private static Set<Entity> visited = new HashSet<Entity>();

    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        if (source.m_81373_() == null) {
            return 0;
        }
        this.searchAndTP(source);
        return 0;
    }

    private void searchAndTP(CommandSourceStack source) {
        Player player = (Player)source.m_81373_();
        int killedEntities = 0;
        for (Entity searchEntity : ((ServerLevel)player.f_19853_).m_8583_()) {
            if (searchEntity instanceof MinecartChest && !visited.contains(searchEntity)) {
                visited.add(searchEntity);
                player.m_6021_(searchEntity.m_20185_(), searchEntity.m_20186_(), searchEntity.m_20189_());
                source.m_81354_((Component)new TextComponent("Found entity:" + searchEntity.m_5446_().getString()), false);
                break;
            }
            if (!(searchEntity instanceof Mob) || searchEntity instanceof Npc) continue;
            if (searchEntity.m_20186_() < 60.0 && ((Mob)searchEntity).m_21532_() && (((Mob)searchEntity).m_6844_(EquipmentSlot.HEAD).m_41720_() == Items.f_42407_ || ((Mob)searchEntity).m_6844_(EquipmentSlot.CHEST).m_41720_() == Items.f_42469_ && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44962_, (ItemStack)((Mob)searchEntity).m_6844_(EquipmentSlot.CHEST)) > 0)) {
                searchEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                ++killedEntities;
                continue;
            }
            if (searchEntity instanceof Animal && searchEntity.f_19853_.m_45527_(searchEntity.m_142538_()) || !((Mob)searchEntity).m_21532_() || visited.contains(searchEntity)) continue;
            boolean isInStructure = false;
            for (Map.Entry entry : ((ServerLevel)searchEntity.f_19853_).m_6325_(searchEntity.m_146903_() >> 4, searchEntity.m_146907_() >> 4).m_6633_().entrySet()) {
                if (!((StructureStart)entry.getValue()).m_73601_().m_71051_((Vec3i)searchEntity.m_142538_())) continue;
                isInStructure = true;
                break;
            }
            if (isInStructure) continue;
            visited.add(searchEntity);
            player.m_6021_(searchEntity.m_20185_(), searchEntity.m_20186_(), searchEntity.m_20189_());
            source.m_81354_((Component)new TextComponent("Found entity:" + searchEntity.m_5446_().getString()), false);
            source.m_81354_((Component)new TextComponent("Killed entities:" + killedEntities), false);
            break;
        }
    }

    @Override
    public String getName() {
        return "tpToPersistent";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("clear", StringArgumentType.string()).executes(this::clearVisited))).executes(this::checkPreConditionAndExecute);
    }

    private int clearVisited(CommandContext<CommandSourceStack> context) {
        if (!this.checkPreCondition(context)) {
            return 0;
        }
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Cleared visited entity list"), false);
        visited = new HashSet<Entity>();
        return 0;
    }
}

