/*
 * Decompiled with CFR 0.152.
 */
package com.hostilevillages.event;

import com.hostilevillages.HostileVillages;
import com.hostilevillages.RandomVillageDataSet;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventHandler {
    private static final int MAX_VILLAGE_DISTANCE = 40000;
    private static BlockPos lastSpawn = BlockPos.f_121853_;
    private static RandomVillageDataSet villageDataSet = new RandomVillageDataSet();
    private static List<Tuple<Entity, ServerLevel>> toAdd = new ArrayList<Tuple<Entity, ServerLevel>>();
    private static EntityType excludedZombieVillager;

    @SubscribeEvent
    public static void onLivingSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getEntity().m_6095_() != EntityType.f_20530_ || event.getEntity().f_19853_.f_46443_) {
            return;
        }
        excludedZombieVillager = event.getEntity().m_6095_();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void preLivingConversionEvent(LivingConversionEvent.Pre event) {
        if (!event.getEntity().f_19853_.f_46443_ && event.getOutcome() == EntityType.f_20530_) {
            excludedZombieVillager = event.getOutcome();
        }
    }

    @SubscribeEvent
    public static void onEntityAdd(EntityJoinWorldEvent event) {
        if (event.getWorld().f_46443_) {
            return;
        }
        if (event.getEntity().m_6095_() == excludedZombieVillager) {
            excludedZombieVillager = null;
            if (((Boolean)HostileVillages.config.getCommonConfig().allowVanillaVillagerSpawn.get()).booleanValue()) {
                return;
            }
        }
        if (EventHandler.replaceEntityOnSpawn(event.getEntity(), (ServerLevelAccessor)event.getWorld())) {
            event.setCanceled(true);
        }
    }

    private static boolean replaceEntityOnSpawn(Entity entity, ServerLevelAccessor world) {
        if (entity.m_6095_() == EntityType.f_20492_ || entity.m_6095_() == EntityType.f_20530_) {
            if (((Boolean)HostileVillages.config.getCommonConfig().allowVanillaVillagerSpawn.get()).booleanValue() && entity.m_6095_() == EntityType.f_20492_) {
                return false;
            }
            if (entity.m_142538_().m_123331_((Vec3i)lastSpawn) > 40000.0 || villageDataSet != null && !villageDataSet.isValid(entity.f_19853_)) {
                villageDataSet = new RandomVillageDataSet();
                villageDataSet.setWorldTimeStart(entity.f_19853_.m_46467_());
            }
            lastSpawn = entity.m_142538_();
            if (villageDataSet == null) {
                return false;
            }
            entity.m_142687_(Entity.RemovalReason.DISCARDED);
            boolean requirePersistance = entity instanceof Mob && ((Mob)entity).m_21532_();
            for (int i = 0; i < (Integer)HostileVillages.config.getCommonConfig().hostilePopulationSize.get(); ++i) {
                Entity replacementEntity = villageDataSet.getEntityReplacement().m_20615_((Level)world.m_6018_());
                if (!(replacementEntity instanceof Mob)) continue;
                if (requirePersistance) {
                    ((Mob)replacementEntity).m_21530_();
                } else if (replacementEntity.m_6095_().m_20674_().m_21610_() || ((Mob)replacementEntity).m_21532_()) continue;
                if (((Boolean)HostileVillages.config.getCommonConfig().debugLog.get()).booleanValue()) {
                    HostileVillages.LOGGER.info("Replacing entity: " + entity + " with entity: " + replacementEntity + " persistence:" + ((Mob)replacementEntity).m_21532_());
                }
                replacementEntity.m_6034_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
                toAdd.add((Tuple<Entity, ServerLevel>)new Tuple((Object)replacementEntity, (Object)world.m_6018_()));
            }
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void addToWorld(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START || event.world.f_46443_) {
            return;
        }
        if (!toAdd.isEmpty()) {
            Tuple<Entity, ServerLevel> tuple = toAdd.remove(0);
            ((ServerLevel)tuple.m_14419_()).m_7967_((Entity)tuple.m_14418_());
            if (villageDataSet != null && tuple.m_14418_() instanceof Mob) {
                villageDataSet.onEntitySpawn((Mob)tuple.m_14418_(), (ServerLevelAccessor)((ServerLevel)event.world));
            }
        }
    }
}

