/*
 * Decompiled with CFR 0.152.
 */
package mcjty.tools.typed;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import mcjty.incontrol.ErrorHandler;
import mcjty.tools.typed.Attribute;
import mcjty.tools.typed.AttributeMap;
import mcjty.tools.typed.Key;
import mcjty.tools.typed.Type;
import mcjty.tools.varia.JSonTools;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class GenericAttributeMapFactory {
    private final List<Attribute> attributes = new ArrayList<Attribute>();

    public GenericAttributeMapFactory attribute(@Nonnull Attribute a) {
        this.attributes.add(a);
        return this;
    }

    @Nonnull
    public AttributeMap parse(@Nonnull JsonElement element) {
        JsonObject jsonObject = element.getAsJsonObject();
        AttributeMap map = new AttributeMap();
        for (Attribute attribute : this.attributes) {
            Key key = attribute.getKey();
            Type type = key.getType();
            if (attribute.isMulti()) {
                Function<JsonElement, Object> transformer = type == Type.INTEGER ? JsonElement::getAsInt : (type == Type.FLOAT ? JsonElement::getAsFloat : (type == Type.BOOLEAN ? JsonElement::getAsBoolean : (type == Type.STRING ? JsonElement::getAsString : (type == Type.JSON ? JsonElement::toString : (type == Type.DIMENSION_TYPE ? jsonElement -> {
                    RegistryKey worldkey = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(jsonElement.getAsString()));
                    MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                    if (server != null && !server.func_240770_D_().contains(worldkey)) {
                        ErrorHandler.error("Dimension '" + jsonElement.getAsString() + "' not found!");
                    }
                    return worldkey;
                } : e -> "INVALID")))));
                JSonTools.getElement(jsonObject, key.getName()).ifPresent(e -> JSonTools.asArrayOrSingle(e).map(transformer).forEach(s -> map.addListNonnull(key, s)));
                continue;
            }
            if (type == Type.INTEGER) {
                map.setNonnull(key, JSonTools.parseInt(jsonObject, key.getName()));
                continue;
            }
            if (type == Type.FLOAT) {
                map.setNonnull(key, JSonTools.parseFloat(jsonObject, key.getName()));
                continue;
            }
            if (type == Type.BOOLEAN) {
                map.setNonnull(key, JSonTools.parseBool(jsonObject, key.getName()));
                continue;
            }
            if (type == Type.STRING) {
                if (!jsonObject.has(key.getName())) continue;
                map.setNonnull(key, jsonObject.get(key.getName()).getAsString());
                continue;
            }
            if (type == Type.DIMENSION_TYPE) {
                if (!jsonObject.has(key.getName())) continue;
                JsonElement jsonElement2 = jsonObject.get(key.getName());
                map.setNonnull(key, RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(jsonElement2.getAsString())));
                continue;
            }
            if (type != Type.JSON || !jsonObject.has(key.getName())) continue;
            JsonElement el = jsonObject.get(key.getName());
            if (el.isJsonObject()) {
                JsonObject obj = el.getAsJsonObject();
                map.setNonnull(key, obj.toString());
                continue;
            }
            if (!el.isJsonPrimitive()) continue;
            JsonPrimitive prim = el.getAsJsonPrimitive();
            if (prim.isString()) {
                map.setNonnull(key, prim.getAsString());
                continue;
            }
            if (prim.isNumber()) {
                map.setNonnull(key, "" + prim.getAsInt());
                continue;
            }
            throw new RuntimeException("Bad type for key '" + key.getName() + "'!");
        }
        return map;
    }
}

