/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.Logger;

public class ItemConfigHelper {
    private final List<ItemStack> itemStackList = new ArrayList<ItemStack>();

    public ItemConfigHelper(List<? extends String> items, Logger logger) {
        for (String string : items) {
            try {
                CompoundTag nbt = TagParser.m_129359_((String)string);
                ResourceLocation resourceLocation = new ResourceLocation(nbt.m_128461_("nameId"));
                Item item = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
                if (item != null) {
                    ItemStack itemStack = new ItemStack((ItemLike)item);
                    nbt.m_128473_("nameId");
                    if (!nbt.m_128456_()) {
                        itemStack.m_41751_(nbt);
                    }
                    this.itemStackList.add(itemStack);
                    logger.info("item config parser identified itemstack {}", (Object)itemStack);
                    continue;
                }
                logger.error("item config parser could not identify item by resourcelocation {}", (Object)resourceLocation);
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
        }
        logger.info("item config parser finished, item count: {}", (Object)this.itemStackList.size());
    }

    public static String fromItemStack(ItemStack itemStack) {
        itemStack.m_41784_().m_128359_("nameId", ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)itemStack.m_41720_()).toString());
        return itemStack.m_41784_().toString();
    }

    public List<ItemStack> getItemStackList() {
        return this.itemStackList;
    }
}

