/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.client;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import atomicstryker.infernalmobs.common.SidedCache;
import atomicstryker.infernalmobs.common.mods.MM_Gravity;
import atomicstryker.infernalmobs.common.network.MobModsPacket;
import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="infernalmobs")
public class InfernalMobsClient {
    private static Minecraft mc;

    @SubscribeEvent
    public static void playerLoginToServer(ClientPlayerNetworkEvent.LoggingIn evt) {
        mc = Minecraft.m_91087_();
        InfernalMobsCore.instance().initIfNeeded(evt.getPlayer().m_9236_());
    }

    @SubscribeEvent
    public static void onEntityJoinedWorld(EntityJoinLevelEvent event) {
        if (event.getLevel().f_46443_ && InfernalMobsClient.mc.f_91074_ != null && (event.getEntity() instanceof Mob || event.getEntity() instanceof LivingEntity && event.getEntity() instanceof Enemy)) {
            InfernalMobsCore.instance().networkHelper.sendPacketToServer(new MobModsPacket(InfernalMobsClient.mc.f_91074_.m_7755_().getString(), event.getEntity().m_19879_(), 0));
            InfernalMobsCore.LOGGER.debug("onEntityJoinedWorld {}, ent-id {} querying modifiers from server", (Object)event.getEntity(), (Object)event.getEntity().m_19879_());
        }
    }

    @SubscribeEvent
    public static void playerLoggedOut(ClientPlayerNetworkEvent.LoggingOut evt) {
        if (evt.getPlayer() != null) {
            SidedCache.getInfernalMobs(evt.getPlayer().m_9236_()).clear();
        }
    }

    public static void onHealthPacketForClient(int entID, float health, float maxhealth) {
        Minecraft.m_91087_().m_18689_(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> InfernalMobsClient.onHealthPacket(entID, health, maxhealth)));
    }

    private static void onHealthPacket(int entID, float health, float maxhealth) {
        MobModifier mod;
        Entity ent = Minecraft.m_91087_().f_91073_.m_6815_(entID);
        if (ent instanceof LivingEntity && (mod = InfernalMobsCore.getMobModifiers((LivingEntity)ent)) != null) {
            mod.setActualHealth(health, maxhealth);
        }
    }

    public static void onKnockBackPacket(float xv, float zv) {
        mc.m_18689_(() -> MM_Gravity.knockBack((LivingEntity)InfernalMobsClient.mc.f_91074_, xv, zv));
    }

    public static void onMobModsPacketToClient(String stringData, int entID) {
        InfernalMobsCore.instance().addRemoteEntityModifiers((Level)InfernalMobsClient.mc.f_91073_, entID, stringData);
    }

    public static void onVelocityPacket(float xv, float yv, float zv) {
        mc.m_18689_(() -> InfernalMobsClient.mc.f_91074_.m_5997_((double)xv, (double)yv, (double)zv));
    }

    public static File getMcFolder() {
        return Minecraft.m_91087_().f_91069_;
    }
}

