/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.client;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import atomicstryker.infernalmobs.common.network.HealthPacket;
import atomicstryker.infernalmobs.common.network.MobModsPacket;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.BossHealthOverlay;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.BossEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD, modid="infernalmobs")
public class OverlayBossBar {
    private static final double NAME_VISION_DISTANCE = 32.0;
    private static final ResourceLocation GUI_BARS_LOCATION = new ResourceLocation("textures/gui/bars.png");
    private static Minecraft mc;
    private static long healthBarRetainTime;
    private static LivingEntity retainedTarget;
    private static long nextPacketTime;
    private static LinkedHashMap<UUID, LerpingBossEvent> vanillaBossEventsMap;

    @SubscribeEvent
    public static void onRegisterGuis(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("infernalmobs_bossbar", (IGuiOverlay)new InfernalMobsHealthBarGuiOverlay());
        mc = Minecraft.m_91087_();
        healthBarRetainTime = 0L;
        retainedTarget = null;
        nextPacketTime = 0L;
    }

    private static void drawModifiersUnderHealthBar(GuiGraphics guiGraphics, MobModifier mod) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_BARS_LOCATION);
        int screenwidth = mc.m_91268_().m_85445_();
        Font fontR = OverlayBossBar.mc.f_91062_;
        int yCoord = 10;
        String[] display = mod.getDisplayNames();
        for (int i = 0; i < display.length && display[i] != null; ++i) {
            guiGraphics.m_280488_(OverlayBossBar.mc.f_91062_, display[i], screenwidth / 2 - fontR.m_92895_(display[i]) / 2, yCoord += 10, 0xFFFFFF);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
    }

    private static LivingEntity getEntityCrosshairOver(float partialTicks, Minecraft mc) {
        Entity entity = mc.m_91288_();
        if (entity != null && mc.f_91073_ != null) {
            AABB axisalignedbb;
            double distance = 32.0;
            HitResult result = entity.m_19907_(distance, partialTicks, false);
            Vec3 vec3d = entity.m_20299_(partialTicks);
            double distanceToHit = result.m_82450_().m_82557_(vec3d);
            Vec3 vec3d1 = entity.m_20252_(1.0f);
            Vec3 vec3d2 = vec3d.m_82520_(vec3d1.f_82479_ * distance, vec3d1.f_82480_ * distance, vec3d1.f_82481_ * distance);
            EntityHitResult entityraytraceresult = ProjectileUtil.m_37287_((Entity)entity, (Vec3)vec3d, (Vec3)vec3d2, (AABB)(axisalignedbb = entity.m_20191_().m_82369_(vec3d1.m_82490_(distance)).m_82377_(1.0, 1.0, 1.0)), p_lambda$getMouseOver$0_0_ -> !p_lambda$getMouseOver$0_0_.m_5833_() && p_lambda$getMouseOver$0_0_.m_6087_(), (double)distanceToHit);
            if (entityraytraceresult != null) {
                Entity entity1 = entityraytraceresult.m_82443_();
                Vec3 vec3d3 = entityraytraceresult.m_82450_();
                double d2 = vec3d.m_82557_(vec3d3);
                if (d2 < distanceToHit && entity1 instanceof LivingEntity) {
                    return (LivingEntity)entity1;
                }
            }
        }
        return null;
    }

    private static void askServerMods(Entity ent) {
        if (System.currentTimeMillis() > nextPacketTime && (ent instanceof Mob || ent instanceof LivingEntity && ent instanceof Enemy)) {
            InfernalMobsCore.instance().networkHelper.sendPacketToServer(new MobModsPacket(OverlayBossBar.mc.f_91074_.m_7755_().getString(), ent.m_19879_(), 0));
            InfernalMobsCore.LOGGER.debug("askServerMods {}, ent-id {} querying modifiers from server", (Object)ent, (Object)ent.m_19879_());
            nextPacketTime = System.currentTimeMillis() + 250L;
        }
    }

    private static void askServerHealth(Entity ent) {
        if (System.currentTimeMillis() > nextPacketTime) {
            InfernalMobsCore.instance().networkHelper.sendPacketToServer(new HealthPacket(OverlayBossBar.mc.f_91074_.m_7755_().getString(), ent.m_19879_(), 0.0f, 0.0f));
            nextPacketTime = System.currentTimeMillis() + 250L;
        }
    }

    static {
        vanillaBossEventsMap = null;
    }

    public static class InfernalMobsHealthBarGuiOverlay
    implements IGuiOverlay {
        public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
            if (InfernalMobsCore.instance().getIsHealthBarDisabled() || OverlayBossBar.mc.f_91065_.m_93090_().m_93713_()) {
                return;
            }
            LivingEntity ent = OverlayBossBar.getEntityCrosshairOver(partialTick, mc);
            boolean retained = false;
            if (ent == null && System.currentTimeMillis() < healthBarRetainTime) {
                ent = retainedTarget;
                retained = true;
            } else if (retainedTarget != null) {
                vanillaBossEventsMap.remove(retainedTarget.m_20148_());
                retainedTarget = null;
            }
            if (vanillaBossEventsMap == null) {
                boolean hackSuccess = false;
                for (Field declaredField : BossHealthOverlay.class.getDeclaredFields()) {
                    if (declaredField.getType() != Map.class) continue;
                    declaredField.setAccessible(true);
                    try {
                        vanillaBossEventsMap = (LinkedHashMap)declaredField.get(OverlayBossBar.mc.f_91065_.m_93090_());
                        hackSuccess = true;
                    }
                    catch (IllegalAccessException e) {
                        hackSuccess = false;
                    }
                }
                if (!hackSuccess) {
                    vanillaBossEventsMap = new LinkedHashMap();
                }
            }
            if (ent != null) {
                MobModifier mod = InfernalMobsCore.getMobModifiers(ent);
                if (mod != null) {
                    BossEvent.BossBarColor color;
                    int modStr;
                    OverlayBossBar.askServerHealth((Entity)ent);
                    UUID uuid = ent.m_20148_();
                    MutableComponent name = Component.m_237113_((String)mod.getEntityDisplayName(ent));
                    float progress = mod.getActualHealth(ent) / mod.getActualMaxHealth(ent);
                    if (ent.m_21224_()) {
                        progress = 0.01f;
                    }
                    BossEvent.BossBarColor bossBarColor = (modStr = mod.getModSize()) <= 5 ? BossEvent.BossBarColor.GREEN : (color = modStr <= 10 ? BossEvent.BossBarColor.YELLOW : BossEvent.BossBarColor.RED);
                    if (!vanillaBossEventsMap.containsKey(uuid)) {
                        vanillaBossEventsMap.put(uuid, new LerpingBossEvent(uuid, (Component)name, progress, color, BossEvent.BossBarOverlay.PROGRESS, false, false, false));
                    } else {
                        LerpingBossEvent bossEvent = vanillaBossEventsMap.get(uuid);
                        bossEvent.m_142711_(progress);
                    }
                    if (vanillaBossEventsMap.size() == 1) {
                        OverlayBossBar.drawModifiersUnderHealthBar(guiGraphics, mod);
                    }
                    if (!retained) {
                        retainedTarget = ent;
                        healthBarRetainTime = System.currentTimeMillis() + 3000L;
                    }
                } else {
                    OverlayBossBar.askServerMods((Entity)ent);
                }
            }
        }
    }
}

