/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common;

import atomicstryker.infernalmobs.common.MobModifier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityTeleportEvent;

public abstract class AbstractTeleporter
extends MobModifier {
    public AbstractTeleporter() {
    }

    public AbstractTeleporter(MobModifier next) {
        super(next);
    }

    protected boolean tryTeleportWithTarget(LivingEntity mob, Entity targetEnt) {
        int attempts;
        double startX = mob.m_20185_();
        double startY = mob.m_20186_();
        double startZ = mob.m_20189_();
        if (mob.m_20270_(targetEnt) > 8.0f) {
            for (attempts = 0; attempts < 5; ++attempts) {
                if (!this.tryTeleportTowardsEntity(mob, targetEnt)) continue;
                this.playStartEffects(mob, startX, startY, startZ);
                return true;
            }
        }
        for (attempts = 0; attempts < 5; ++attempts) {
            if (!this.teleportRandomly(mob)) continue;
            this.playStartEffects(mob, startX, startY, startZ);
            return true;
        }
        return false;
    }

    protected boolean teleportRandomly(LivingEntity mob) {
        if (!mob.m_9236_().m_5776_() && mob.m_6084_()) {
            double d0 = mob.m_20185_() + (mob.m_217043_().m_188500_() - 0.5) * 64.0;
            double d1 = mob.m_20186_() + (double)(mob.m_217043_().m_188503_(64) - 32);
            double d2 = mob.m_20189_() + (mob.m_217043_().m_188500_() - 0.5) * 64.0;
            return this.tryTeleportTo(mob, d0, d1, d2);
        }
        return false;
    }

    protected boolean tryTeleportTowardsEntity(LivingEntity mob, Entity targetEnt) {
        Vec3 vec3 = new Vec3(mob.m_20185_() - targetEnt.m_20185_(), mob.m_20227_(0.5) - targetEnt.m_20188_(), mob.m_20189_() - targetEnt.m_20189_());
        vec3 = vec3.m_82541_();
        double d1 = mob.m_20185_() + (mob.m_217043_().m_188500_() - 0.5) * 8.0 - vec3.f_82479_ * 16.0;
        double d2 = mob.m_20186_() + (double)(mob.m_217043_().m_188503_(16) - 8) - vec3.f_82480_ * 16.0;
        double d3 = mob.m_20189_() + (mob.m_217043_().m_188500_() - 0.5) * 8.0 - vec3.f_82481_ * 16.0;
        return this.tryTeleportTo(mob, d1, d2, d3);
    }

    protected boolean tryTeleportTo(LivingEntity mob, double x, double y, double z) {
        BlockPos.MutableBlockPos destination = new BlockPos.MutableBlockPos(x, y, z);
        while (destination.m_123342_() > mob.m_9236_().m_141937_() && !mob.m_9236_().m_8055_((BlockPos)destination).m_280555_()) {
            destination.m_122173_(Direction.DOWN);
        }
        BlockState destinationFloorState = mob.m_9236_().m_8055_((BlockPos)destination);
        boolean blocksMotion = destinationFloorState.m_280555_();
        boolean isWater = destinationFloorState.m_60819_().m_205070_(FluidTags.f_13131_);
        if (blocksMotion && !isWater) {
            EntityTeleportEvent forgeEvent = this.getForgeEvent(mob, x, y, z);
            if (forgeEvent.isCanceled()) {
                return false;
            }
            Vec3 vec3 = mob.m_20182_();
            boolean teleportResult = mob.m_20984_(forgeEvent.getTargetX(), forgeEvent.getTargetY(), forgeEvent.getTargetZ(), true);
            if (teleportResult) {
                mob.m_9236_().m_214171_(GameEvent.f_238175_, vec3, GameEvent.Context.m_223717_((Entity)mob));
                if (!mob.m_20067_()) {
                    this.playDestinationEffects(mob);
                }
            }
            return teleportResult;
        }
        return false;
    }

    protected void playStartEffects(LivingEntity mob, double x, double y, double z) {
    }

    protected void playDestinationEffects(LivingEntity mob) {
        mob.m_9236_().m_6263_(null, mob.f_19854_, mob.f_19855_, mob.f_19856_, SoundEvents.f_11852_, mob.m_5720_(), 1.0f, 1.0f);
        mob.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
    }

    protected EntityTeleportEvent getForgeEvent(LivingEntity mob, double x, double y, double z) {
        return new EntityTeleportEvent((Entity)mob, x, y, z);
    }
}

