/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common.mods;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import atomicstryker.infernalmobs.common.mods.MM_Webber;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class MM_Gravity
extends MobModifier {
    private static final long coolDown = 5000L;
    private static Class<?>[] modBans = new Class[]{MM_Webber.class};
    private static String[] suffix = new String[]{"ofRepulsion", "theFlipper"};
    private static String[] prefix = new String[]{"repulsing", "sproing"};
    private long nextAbilityUse = 0L;

    public MM_Gravity() {
    }

    public MM_Gravity(MobModifier next) {
        super(next);
    }

    public static void knockBack(LivingEntity target, double x, double z) {
        target.f_19812_ = true;
        float normalizedPower = Mth.m_14116_((float)((float)(x * x + z * z)));
        float knockPower = 0.8f;
        double motionX = target.m_20184_().f_82479_;
        double motionY = target.m_20184_().f_82479_;
        double motionZ = target.m_20184_().f_82479_;
        motionX /= 2.0;
        motionY /= 2.0;
        motionZ /= 2.0;
        motionX -= x / (double)normalizedPower * (double)knockPower;
        motionY += (double)knockPower;
        motionZ -= z / (double)normalizedPower * (double)knockPower;
        if (motionY > (double)0.4f) {
            motionY = 0.4f;
        }
        target.m_20334_(motionX, motionY, motionZ);
    }

    @Override
    public String getModName() {
        return "Gravity";
    }

    @Override
    public boolean onUpdate(LivingEntity mob) {
        if (this.hasSteadyTarget() && this.getMobTarget() instanceof Player) {
            this.tryAbility(mob, this.getMobTarget());
        }
        return super.onUpdate(mob);
    }

    private void tryAbility(LivingEntity mob, LivingEntity target) {
        if (target == null || !this.canMobSeeTarget(mob, target)) {
            return;
        }
        long time = System.currentTimeMillis();
        if (time > this.nextAbilityUse) {
            this.nextAbilityUse = time + 5000L;
            double diffX = target.m_20185_() - mob.m_20185_();
            double diffZ = target.m_20189_() - mob.m_20189_();
            while (diffX * diffX + diffZ * diffZ < 1.0E-4) {
                diffX = (Math.random() - Math.random()) * 0.01;
                diffZ = (Math.random() - Math.random()) * 0.01;
            }
            mob.m_9236_().m_5594_(null, mob.m_20183_(), SoundEvents.f_12057_, SoundSource.HOSTILE, 1.0f + mob.m_217043_().m_188501_(), mob.m_217043_().m_188501_() * 0.7f + 0.3f);
            if (mob.m_9236_().f_46443_ || !(target instanceof ServerPlayer)) {
                MM_Gravity.knockBack(target, diffX, diffZ);
            } else {
                InfernalMobsCore.instance().sendKnockBackPacket((ServerPlayer)target, (float)diffX, (float)diffZ);
            }
        }
    }

    @Override
    public Class<?>[] getModsNotToMixWith() {
        return modBans;
    }

    @Override
    protected String[] getModNameSuffix() {
        return suffix;
    }

    @Override
    protected String[] getModNamePrefix() {
        return prefix;
    }
}

