/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD, modid="infernalmobs")
public class OverlayChoking {
    protected static final ResourceLocation GUI_ICONS_LOCATION = new ResourceLocation("textures/gui/icons.png");
    private static Minecraft mc;
    private static int airOverrideValue;
    private static long airDisplayTimeout;

    public static void onAirPacket(int air) {
        airOverrideValue = air;
        airDisplayTimeout = System.currentTimeMillis() + 3000L;
    }

    @SubscribeEvent
    public static void onRegisterGuis(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("infernalmobs_choking", (IGuiOverlay)new InfernalMobsChokingGuiOverlay());
        mc = Minecraft.m_91087_();
    }

    private static int getVehicleMaxHearts(LivingEntity livingEntity) {
        if (livingEntity != null && livingEntity.m_20152_()) {
            float maxHealth = livingEntity.m_21233_();
            int roundedHalf = (int)(maxHealth + 0.5f) / 2;
            if (roundedHalf > 30) {
                roundedHalf = 30;
            }
            return roundedHalf;
        }
        return 0;
    }

    private static int getVisibleVehicleHeartRows(int heartCount) {
        return (int)Math.ceil((double)heartCount / 10.0);
    }

    static {
        airOverrideValue = -999;
    }

    public static class InfernalMobsChokingGuiOverlay
    implements IGuiOverlay {
        public void render(ForgeGui gui, GuiGraphics guiGraphics, float partialTick, int screenWidth, int screenHeight) {
            if (System.currentTimeMillis() > airDisplayTimeout) {
                airOverrideValue = -999;
            }
            if (!OverlayChoking.mc.f_91074_.m_204029_(FluidTags.f_13131_) && airOverrideValue != -999) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_ICONS_LOCATION);
                int leftScreenCoordinate = mc.m_91268_().m_85445_() / 2 + 91;
                int topScreenCoordinate = mc.m_91268_().m_85446_() - 59;
                int maxHearts = OverlayChoking.getVehicleMaxHearts((LivingEntity)OverlayChoking.mc.f_91074_);
                int maxAir = OverlayChoking.mc.f_91074_.m_6062_();
                int currentAir = Math.min(airOverrideValue, maxAir);
                int rowCount = OverlayChoking.getVisibleVehicleHeartRows(maxHearts) - 1;
                topScreenCoordinate -= rowCount * 10;
                int fullBubbles = Mth.m_14165_((double)((double)(currentAir - 2) * 10.0 / (double)maxAir));
                int partialBubbles = Mth.m_14165_((double)((double)currentAir * 10.0 / (double)maxAir)) - fullBubbles;
                for (int j5 = 0; j5 < fullBubbles + partialBubbles; ++j5) {
                    if (j5 < fullBubbles) {
                        guiGraphics.m_280218_(GUI_ICONS_LOCATION, leftScreenCoordinate - j5 * 8 - 9, topScreenCoordinate, 16, 18, 9, 9);
                        continue;
                    }
                    guiGraphics.m_280218_(GUI_ICONS_LOCATION, leftScreenCoordinate - j5 * 8 - 9, topScreenCoordinate, 25, 18, 9, 9);
                }
            }
        }
    }
}

