/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;

public class GsonConfig {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public static <T> T loadConfigWithDefault(Class<T> clazz, File file, T defaultInstance) {
        try {
            if (file.createNewFile()) {
                String json = gson.toJson(JsonParser.parseString((String)gson.toJson(defaultInstance)));
                try (PrintWriter out = new PrintWriter(file);){
                    out.println(json);
                }
                return defaultInstance;
            }
            return (T)gson.fromJson(new String(Files.readAllBytes(file.toPath())), clazz);
        }
        catch (IOException e) {
            throw new UnsupportedOperationException("Config failed parsing json file somehow, read logfile");
        }
    }

    public static void saveConfig(Object config, File file) {
        block9: {
            try {
                String jsonNew = gson.toJson(JsonParser.parseString((String)gson.toJson(config)));
                if (file.exists()) {
                    String jsonOld = new String(Files.readAllBytes(file.toPath()));
                    if (jsonNew.equals(jsonOld)) {
                        return;
                    }
                    file.delete();
                }
                if (!file.createNewFile()) break block9;
                try (PrintWriter out = new PrintWriter(file);){
                    out.println(jsonNew);
                }
            }
            catch (IOException e) {
                throw new UnsupportedOperationException("Config failed saving gson file somehow, read logfile");
            }
        }
    }
}

