/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common.network;

import atomicstryker.infernalmobs.client.InfernalMobsClient;
import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

public record HealthPacket(String stringData, int entID, float health, float maxhealth) {
    public void encode(FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130070_(this.stringData);
        packetBuffer.writeInt(this.entID);
        packetBuffer.writeFloat(this.health);
        packetBuffer.writeFloat(this.maxhealth);
    }

    public static HealthPacket decode(FriendlyByteBuf packetBuffer) {
        return new HealthPacket(packetBuffer.m_130136_(Short.MAX_VALUE), packetBuffer.readInt(), packetBuffer.readFloat(), packetBuffer.readFloat());
    }

    public static void handle(HealthPacket healthPacket, CustomPayloadEvent.Context context) {
        context.enqueueWork(() -> {
            if (healthPacket.maxhealth > 0.0f) {
                InfernalMobsClient.onHealthPacketForClient(healthPacket.entID, healthPacket.health, healthPacket.maxhealth);
            } else {
                LivingEntity e;
                MobModifier mod;
                Entity ent;
                ServerPlayer p = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11255_(healthPacket.stringData);
                if (p != null && (ent = p.m_9236_().m_6815_(healthPacket.entID)) instanceof LivingEntity && (mod = InfernalMobsCore.getMobModifiers(e = (LivingEntity)ent)) != null) {
                    HealthPacket response = new HealthPacket(healthPacket.stringData, healthPacket.entID(), e.m_21223_(), e.m_21233_());
                    InfernalMobsCore.networkChannel.send((Object)response, PacketDistributor.PLAYER.with((Object)p));
                }
            }
        });
        context.setPacketHandled(true);
    }

    public String getStringData() {
        return this.stringData;
    }

    public int getEntID() {
        return this.entID;
    }

    public float getHealth() {
        return this.health;
    }

    public float getMaxhealth() {
        return this.maxhealth;
    }
}

