/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common.network;

import atomicstryker.infernalmobs.client.InfernalMobsClient;
import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

public record MobModsPacket(String stringData, int entID, byte sentFromServer) {
    public void encode(FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130072_(this.stringData, Short.MAX_VALUE);
        packetBuffer.writeInt(this.entID);
        packetBuffer.writeByte((int)this.sentFromServer);
    }

    public static MobModsPacket decode(FriendlyByteBuf packetBuffer) {
        return new MobModsPacket(packetBuffer.m_130136_(Short.MAX_VALUE), packetBuffer.readInt(), packetBuffer.readByte());
    }

    public static void handle(MobModsPacket mobModsPacket, CustomPayloadEvent.Context context) {
        if (mobModsPacket.sentFromServer != 0) {
            InfernalMobsClient.onMobModsPacketToClient(mobModsPacket.stringData, mobModsPacket.entID);
            InfernalMobsCore.LOGGER.debug("client received serverside mods {} for ent-ID {}", (Object)mobModsPacket.stringData, (Object)mobModsPacket.entID);
        } else {
            Entity ent;
            ServerPlayer p = ServerLifecycleHooks.getCurrentServer().m_6846_().m_11255_(mobModsPacket.stringData);
            InfernalMobsCore.LOGGER.debug("player {} from string {} querying server for mods of entity id {}", (Object)p, (Object)mobModsPacket.stringData, (Object)mobModsPacket.entID);
            if (p != null && (ent = p.m_9236_().m_6815_(mobModsPacket.entID)) instanceof LivingEntity) {
                LivingEntity e = (LivingEntity)ent;
                MobModifier mod = InfernalMobsCore.getMobModifiers(e);
                InfernalMobsCore.LOGGER.debug("resolves to entity {} modifiers {}", (Object)ent, (Object)mod);
                if (mod != null) {
                    MobModsPacket response = new MobModsPacket(mod.getLinkedModNameUntranslated(), mobModsPacket.entID, 1);
                    InfernalMobsCore.LOGGER.debug("server sending mods {} for ent-ID {}", (Object)response.stringData, (Object)response.entID);
                    InfernalMobsCore.networkChannel.send((Object)response, PacketDistributor.PLAYER.with((Object)p));
                    InfernalMobsCore.instance().sendHealthPacket(e);
                }
            }
        }
        context.setPacketHandled(true);
    }
}

