/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.data;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.levelz.data.LevelLists;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LevelLoader
implements SimpleSynchronousResourceReloadListener {
    private static final Logger LOGGER = LogManager.getLogger((String)"LevelZ");
    private List<List<Integer>> objectList = new ArrayList<List<Integer>>();
    private List<Integer> levelList = new ArrayList<Integer>();

    public class_2960 getFabricId() {
        return new class_2960("levelz", "level_loader");
    }

    public void method_14491(class_3300 manager) {
        JsonObject data;
        InputStream stream;
        LevelLoader.clearEveryList();
        for (class_2960 id : manager.method_14488("mining", path -> path.endsWith(".json"))) {
            try {
                stream = manager.method_14486(id).method_14482();
                data = new JsonParser().parse((Reader)new InputStreamReader(stream)).getAsJsonObject();
                if (this.levelList.contains(data.get("level").getAsInt())) {
                    if (class_3518.method_15258((JsonObject)data, (String)"replace", (boolean)false)) {
                        int index = this.levelList.indexOf(data.get("level").getAsInt());
                        this.levelList.remove(index);
                        this.objectList.remove(index);
                        this.fillLists(data, false, 1);
                        continue;
                    }
                    this.fillLists(data, true, 1);
                    continue;
                }
                this.fillLists(data, false, 1);
            }
            catch (Exception e) {
                LOGGER.error("Error occurred while loading resource {}. {}", (Object)id.toString(), (Object)e.toString());
            }
        }
        this.sortAndFillLists(this.levelList, this.objectList, 1);
        for (class_2960 id : manager.method_14488("item", path -> path.endsWith(".json"))) {
            try {
                stream = manager.method_14486(id).method_14482();
                data = new JsonParser().parse((Reader)new InputStreamReader(stream)).getAsJsonObject();
                ArrayList<Object> list = LevelLists.getList(data.get("item").getAsString());
                if (data.get("item").getAsString().equals("minecraft:armor") || data.get("item").getAsString().equals("minecraft:tool") || data.get("item").getAsString().equals("minecraft:hoe") || data.get("item").getAsString().equals("minecraft:sword") || data.get("item").getAsString().equals("minecraft:axe")) {
                    if (list.contains(data.get("material").getAsString())) {
                        if (class_3518.method_15258((JsonObject)data, (String)"replace", (boolean)false)) {
                            int removeLines = list.indexOf(data.get("material").getAsString());
                            for (int i = 0; i < 5; ++i) {
                                list.remove(removeLines);
                            }
                        } else {
                            if (((Boolean)list.get(list.indexOf(data.get("material")) + 4)).booleanValue()) continue;
                            LOGGER.info("Resource {} was not loaded cause it already existed", (Object)id.toString());
                            continue;
                        }
                    }
                    list.add(data.get("material").getAsString());
                    list.add(data.get("skill").getAsString());
                    list.add(data.get("level").getAsInt());
                    list.add(data.get("item").getAsString());
                    list.add(class_3518.method_15258((JsonObject)data, (String)"replace", (boolean)false));
                    continue;
                }
                if (!list.isEmpty()) {
                    if (class_3518.method_15258((JsonObject)data, (String)"replace", (boolean)false)) {
                        list.clear();
                    } else {
                        if (((Boolean)list.get(3)).booleanValue()) continue;
                        LOGGER.info("Resource {} was not loaded cause it already existed", (Object)id.toString());
                        continue;
                    }
                }
                list.add(data.get("skill").getAsString());
                list.add(data.get("level").getAsInt());
                list.add(data.get("item").getAsString());
                list.add(class_3518.method_15258((JsonObject)data, (String)"replace", (boolean)false));
            }
            catch (Exception e) {
                LOGGER.error("Error occurred while loading resource {}. {}", (Object)id.toString(), (Object)e.toString());
            }
        }
        for (class_2960 id : manager.method_14488("block", path -> path.endsWith(".json"))) {
            try {
                stream = manager.method_14486(id).method_14482();
                data = new JsonParser().parse((Reader)new InputStreamReader(stream)).getAsJsonObject();
                ArrayList<Object> list = LevelLists.getList(data.get("block").getAsString());
                if (!list.isEmpty()) {
                    if (class_3518.method_15258((JsonObject)data, (String)"replace", (boolean)false)) {
                        list.clear();
                    } else {
                        if (((Boolean)list.get(3)).booleanValue()) continue;
                        LOGGER.info("Resource {} was not loaded cause it already existed", (Object)id.toString());
                        continue;
                    }
                }
                list.add(data.get("skill").getAsString());
                list.add(data.get("level").getAsInt());
                list.add(data.get("block").getAsString());
                list.add(class_3518.method_15258((JsonObject)data, (String)"replace", (boolean)false));
                if (data.get("enchanting") == null) continue;
                for (int i = 0; i < data.getAsJsonArray("enchanting").size(); ++i) {
                    list.add(data.get("enchanting").getAsJsonArray().get(i).getAsInt());
                }
            }
            catch (Exception e) {
                LOGGER.error("Error occurred while loading resource {}. {}", (Object)id.toString(), (Object)e.toString());
            }
        }
        for (class_2960 id : manager.method_14488("entity", path -> path.endsWith(".json"))) {
            try {
                stream = manager.method_14486(id).method_14482();
                data = new JsonParser().parse((Reader)new InputStreamReader(stream)).getAsJsonObject();
                ArrayList<Object> list = LevelLists.getList(data.get("entity").getAsString());
                if (!list.isEmpty()) {
                    if (class_3518.method_15258((JsonObject)data, (String)"replace", (boolean)false)) {
                        list.clear();
                    } else {
                        if (((Boolean)list.get(3)).booleanValue()) continue;
                        LOGGER.info("Resource {} was not loaded cause it already existed", (Object)id.toString());
                        continue;
                    }
                }
                list.add(data.get("skill").getAsString());
                list.add(data.get("level").getAsInt());
                list.add(data.get("entity").getAsString());
                list.add(class_3518.method_15258((JsonObject)data, (String)"replace", (boolean)false));
            }
            catch (Exception e) {
                LOGGER.error("Error occurred while loading resource {}. {}", (Object)id.toString(), (Object)e.toString());
            }
        }
        for (class_2960 id : manager.method_14488("brewing", path -> path.endsWith(".json"))) {
            try {
                stream = manager.method_14486(id).method_14482();
                data = new JsonParser().parse((Reader)new InputStreamReader(stream)).getAsJsonObject();
                if (this.levelList.contains(data.get("level").getAsInt())) {
                    if (class_3518.method_15258((JsonObject)data, (String)"replace", (boolean)false)) {
                        int index = this.levelList.indexOf(data.get("level").getAsInt());
                        this.levelList.remove(index);
                        this.objectList.remove(index);
                        this.fillLists(data, false, 2);
                        continue;
                    }
                    this.fillLists(data, true, 2);
                    continue;
                }
                this.fillLists(data, false, 2);
            }
            catch (Exception e) {
                LOGGER.error("Error occurred while loading resource {}. {}", (Object)id.toString(), (Object)e.toString());
            }
        }
        this.sortAndFillLists(this.levelList, this.objectList, 2);
        LevelLoader.addAllInOneList();
    }

    private void fillLists(JsonObject data, boolean addToExisting, int type) {
        int i;
        ArrayList<Integer> idList = new ArrayList<Integer>();
        if (type == 1) {
            for (i = 0; i < data.getAsJsonArray("block").size(); ++i) {
                idList.add(class_2378.field_11146.method_10206((Object)((class_2248)class_2378.field_11146.method_10223(new class_2960(data.getAsJsonArray("block").get(i).getAsString())))));
            }
        } else if (type == 2) {
            for (i = 0; i < data.getAsJsonArray("item").size(); ++i) {
                idList.add(class_2378.field_11142.method_10206((Object)((class_1792)class_2378.field_11142.method_10223(new class_2960(data.getAsJsonArray("item").get(i).getAsString())))));
            }
        }
        if (addToExisting) {
            int index = this.levelList.indexOf(data.get("level").getAsInt());
            for (int u = 0; u < idList.size(); ++u) {
                this.objectList.get(index).add((Integer)idList.get(u));
            }
        } else {
            this.levelList.add(data.get("level").getAsInt());
            this.objectList.add(idList);
        }
    }

    private void sortAndFillLists(List<Integer> levelList, List<List<Integer>> objectList, int type) {
        if (type != 0) {
            if (type == 1) {
                LevelLists.miningLevelList.addAll(levelList);
                LevelLists.miningLevelList.sort(Comparator.naturalOrder());
                for (int i = 0; i < levelList.size(); ++i) {
                    LevelLists.miningBlockList.add(i, objectList.get(levelList.indexOf(LevelLists.miningLevelList.get(i))));
                }
            } else if (type == 2) {
                LevelLists.brewingLevelList.addAll(levelList);
                LevelLists.brewingLevelList.sort(Comparator.naturalOrder());
                for (int i = 0; i < levelList.size(); ++i) {
                    LevelLists.brewingItemList.add(i, objectList.get(levelList.indexOf(LevelLists.brewingLevelList.get(i))));
                }
            }
            this.objectList.clear();
            this.levelList.clear();
        }
    }

    public static void addAllInOneList() {
        LevelLists.listOfAllLists.add(LevelLists.anvilList);
        LevelLists.listOfAllLists.add(LevelLists.armorList);
        LevelLists.listOfAllLists.add(LevelLists.axeList);
        LevelLists.listOfAllLists.add(LevelLists.barrelList);
        LevelLists.listOfAllLists.add(LevelLists.beehiveList);
        LevelLists.listOfAllLists.add(LevelLists.blastFurnaceList);
        LevelLists.listOfAllLists.add(LevelLists.bowList);
        LevelLists.listOfAllLists.add(LevelLists.brewingStandList);
        LevelLists.listOfAllLists.add(LevelLists.bucketList);
        LevelLists.listOfAllLists.add(LevelLists.cartographyList);
        LevelLists.listOfAllLists.add(LevelLists.cauldronList);
        LevelLists.listOfAllLists.add(LevelLists.composterList);
        LevelLists.listOfAllLists.add(LevelLists.cowList);
        LevelLists.listOfAllLists.add(LevelLists.crossbowList);
        LevelLists.listOfAllLists.add(LevelLists.dragonBreathList);
        LevelLists.listOfAllLists.add(LevelLists.elytraList);
        LevelLists.listOfAllLists.add(LevelLists.enchantingTableList);
        LevelLists.listOfAllLists.add(LevelLists.fishingList);
        LevelLists.listOfAllLists.add(LevelLists.flintAndSteelList);
        LevelLists.listOfAllLists.add(LevelLists.grindstoneList);
        LevelLists.listOfAllLists.add(LevelLists.hoeList);
        LevelLists.listOfAllLists.add(LevelLists.lecternList);
        LevelLists.listOfAllLists.add(LevelLists.loomList);
        LevelLists.listOfAllLists.add(LevelLists.mooshroomList);
        LevelLists.listOfAllLists.add(LevelLists.pumpkinList);
        LevelLists.listOfAllLists.add(LevelLists.sheepList);
        LevelLists.listOfAllLists.add(LevelLists.shieldList);
        LevelLists.listOfAllLists.add(LevelLists.smithingTableList);
        LevelLists.listOfAllLists.add(LevelLists.smokerList);
        LevelLists.listOfAllLists.add(LevelLists.snowGolemList);
        LevelLists.listOfAllLists.add(LevelLists.stonecutterList);
        LevelLists.listOfAllLists.add(LevelLists.swordList);
        LevelLists.listOfAllLists.add(LevelLists.toolList);
        LevelLists.listOfAllLists.add(LevelLists.totemList);
        LevelLists.listOfAllLists.add(LevelLists.tridentList);
        LevelLists.listOfAllLists.add(LevelLists.villagerList);
        LevelLists.listOfAllLists.add(LevelLists.wanderingTraderList);
    }

    public static void clearEveryList() {
        LevelLists.anvilList.clear();
        LevelLists.armorList.clear();
        LevelLists.axeList.clear();
        LevelLists.barrelList.clear();
        LevelLists.beehiveList.clear();
        LevelLists.blastFurnaceList.clear();
        LevelLists.bowList.clear();
        LevelLists.brewingStandList.clear();
        LevelLists.bucketList.clear();
        LevelLists.cartographyList.clear();
        LevelLists.cauldronList.clear();
        LevelLists.composterList.clear();
        LevelLists.cowList.clear();
        LevelLists.crossbowList.clear();
        LevelLists.dragonBreathList.clear();
        LevelLists.elytraList.clear();
        LevelLists.enchantingTableList.clear();
        LevelLists.fishingList.clear();
        LevelLists.flintAndSteelList.clear();
        LevelLists.grindstoneList.clear();
        LevelLists.hoeList.clear();
        LevelLists.lecternList.clear();
        LevelLists.loomList.clear();
        LevelLists.mooshroomList.clear();
        LevelLists.pumpkinList.clear();
        LevelLists.sheepList.clear();
        LevelLists.shieldList.clear();
        LevelLists.smithingTableList.clear();
        LevelLists.smokerList.clear();
        LevelLists.snowGolemList.clear();
        LevelLists.stonecutterList.clear();
        LevelLists.swordList.clear();
        LevelLists.toolList.clear();
        LevelLists.totemList.clear();
        LevelLists.tridentList.clear();
        LevelLists.villagerList.clear();
        LevelLists.wanderingTraderList.clear();
        LevelLists.miningBlockList.clear();
        LevelLists.miningLevelList.clear();
        LevelLists.brewingItemList.clear();
        LevelLists.brewingLevelList.clear();
        LevelLists.potionList.clear();
    }
}

