/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.mixin.misc;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.levelz.access.PlayerStatsManagerAccess;
import net.levelz.init.ConfigInit;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1706;
import net.minecraft.class_3914;
import net.minecraft.class_3915;
import net.minecraft.class_3917;
import net.minecraft.class_4861;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1706.class})
public abstract class AnvilScreenHandlerMixin
extends class_4861 {
    @Shadow
    @Final
    private class_3915 field_7770;
    private int smithingLevel;

    public AnvilScreenHandlerMixin(@Nullable class_3917<?> type, int syncId, class_1661 playerInventory, class_3914 context) {
        super(type, syncId, playerInventory, context);
        this.smithingLevel = ((PlayerStatsManagerAccess)this.field_22482).getPlayerStatsManager(this.field_22482).getLevel("smithing");
    }

    @Inject(method={"Lnet/minecraft/screen/AnvilScreenHandler;updateResult()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/inventory/CraftingResultInventory;setStack(ILnet/minecraft/item/ItemStack;)V", ordinal=4)})
    private void updateResultMixin(CallbackInfo info) {
        if (this.field_7770.method_17407() > 1) {
            int levelCost = (int)((float)this.field_7770.method_17407() * (1.0f - (float)this.smithingLevel * ConfigInit.CONFIG.smithingCostBonus));
            if (levelCost > 30 && this.smithingLevel == ConfigInit.CONFIG.maxLevel) {
                this.field_7770.method_17404(30);
            } else {
                this.field_7770.method_17404(levelCost);
            }
        }
    }

    @Redirect(method={"onTakeOutput"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;addExperienceLevels(I)V"))
    private void onTakeOutputMixin(class_1657 playerEntity, int levelCost) {
        if (this.smithingLevel != ConfigInit.CONFIG.maxLevel || !(ConfigInit.CONFIG.smithingToolChance > playerEntity.field_6002.field_9229.nextFloat())) {
            this.field_22482.method_7316(-this.field_7770.method_17407());
        }
    }

    @Inject(method={"getLevelCost"}, at={@At(value="HEAD")}, cancellable=true)
    @Environment(value=EnvType.CLIENT)
    public void getLevelCostMixin(CallbackInfoReturnable<Integer> info) {
        if (this.field_7770.method_17407() > 30 && this.smithingLevel == ConfigInit.CONFIG.maxLevel) {
            info.setReturnValue((Object)30);
        }
    }
}

