/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.mixin.player;

import net.levelz.access.PlayerDropAccess;
import net.levelz.access.PlayerStatsManagerAccess;
import net.levelz.data.LevelLists;
import net.levelz.init.ConfigInit;
import net.levelz.network.PlayerStatsServerPacket;
import net.levelz.stats.PlayerStatsManager;
import net.minecraft.class_1282;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2791;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_4174;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public class PlayerEntityMixin
implements PlayerStatsManagerAccess,
PlayerDropAccess {
    private final PlayerStatsManager playerStatsManager = new PlayerStatsManager();
    private final class_1657 playerEntity = (class_1657)this;
    private boolean isCrit;
    private int killedMobsInChunk;
    @Nullable
    private class_2791 killedMobChunk;

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    public void readCustomDataFromNbtMixin(class_2487 tag, CallbackInfo info) {
        this.playerStatsManager.readNbt(tag);
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    public void writeCustomDataToNbtMixin(class_2487 tag, CallbackInfo info) {
        this.playerStatsManager.writeNbt(tag);
    }

    @Inject(method={"addExperience"}, at={@At(value="TAIL")})
    public void addExperienceMixin(int experience, CallbackInfo info) {
        this.playerStatsManager.levelProgress += (float)experience / (float)this.playerStatsManager.getNextLevelExperience();
        this.playerStatsManager.totalLevelExperience = class_3532.method_15340((int)(this.playerStatsManager.totalLevelExperience + experience), (int)0, (int)Integer.MAX_VALUE);
        while (this.playerStatsManager.levelProgress >= 1.0f) {
            this.playerStatsManager.levelProgress = (this.playerStatsManager.levelProgress - 1.0f) * (float)this.playerStatsManager.getNextLevelExperience();
            this.playerStatsManager.addExperienceLevels(1);
            this.playerStatsManager.levelProgress /= (float)this.playerStatsManager.getNextLevelExperience();
            if (this.playerEntity instanceof class_3222) {
                PlayerStatsServerPacket.writeS2CSkillPacket(this.playerStatsManager, (class_3222)this.playerEntity);
            }
            if (this.playerStatsManager.overallLevel <= 0 || this.playerStatsManager.overallLevel % 5 != 0) continue;
            float f = this.playerStatsManager.overallLevel > 30 ? 1.0f : (float)this.playerStatsManager.overallLevel / 30.0f;
            this.playerEntity.field_6002.method_8465((class_1657)null, this.playerEntity.method_23317(), this.playerEntity.method_23318(), this.playerEntity.method_23321(), class_3417.field_14709, this.playerEntity.method_5634(), f * 0.75f, 1.0f);
        }
    }

    @Redirect(method={"addExhaustion"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/player/HungerManager;addExhaustion(F)V"))
    private void addExhaustion(class_1702 hungerManager, float exhaustion) {
        hungerManager.method_7583(exhaustion *= ConfigInit.CONFIG.staminaBase - (float)this.playerStatsManager.getLevel("stamina") * ConfigInit.CONFIG.staminaBonus);
    }

    @ModifyVariable(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;getItem()Lnet/minecraft/item/Item;"), ordinal=2)
    private boolean attackMixin(boolean original) {
        if (this.playerEntity.field_6002.field_9229.nextFloat() < (float)this.playerStatsManager.getLevel("luck") * ConfigInit.CONFIG.luckCritBonus) {
            this.isCrit = true;
            return true;
        }
        this.isCrit = false;
        return original;
    }

    @ModifyVariable(method={"attack"}, at=@At(value="INVOKE", target="Lnet/minecraft/item/ItemStack;getItem()Lnet/minecraft/item/Item;", shift=At.Shift.AFTER), ordinal=0)
    private float attackMixinTwo(float original) {
        if (this.playerStatsManager.getLevel("strength") == ConfigInit.CONFIG.maxLevel && ConfigInit.CONFIG.attackDoubleDamageChance > this.playerEntity.field_6002.field_9229.nextFloat()) {
            return original * 2.0f;
        }
        return this.isCrit ? original * ConfigInit.CONFIG.critDmgBonus : original;
    }

    @ModifyVariable(method={"attack"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/entity/player/PlayerEntity;getAttackCooldownProgress(F)F"), ordinal=0)
    private float attackMixinThree(float original) {
        if (!this.playerEntity.method_7337() && this.playerEntity.method_6047().method_7909() instanceof class_1829 && !PlayerStatsManager.playerLevelisHighEnough(this.playerEntity, LevelLists.swordList, ((class_1829)this.playerEntity.method_6047().method_7909()).method_8022().toString().toLowerCase(), true)) {
            return original - ((class_1829)this.playerEntity.method_6047().method_7909()).method_8020();
        }
        return original;
    }

    @ModifyVariable(method={"attack"}, at=@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/entity/player/PlayerEntity;getAttackCooldownProgress(F)F"), ordinal=1)
    private float attackMixinFour(float original) {
        if (!this.playerEntity.method_7337() && this.playerEntity.method_6047().method_7909() instanceof class_1829 && !PlayerStatsManager.playerLevelisHighEnough(this.playerEntity, LevelLists.swordList, ((class_1829)this.playerEntity.method_6047().method_7909()).method_8022().toString().toLowerCase(), true)) {
            return 0.0f;
        }
        return original;
    }

    @Inject(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;dropShoulderEntities()V", shift=At.Shift.AFTER)}, cancellable=true)
    private void damageMixin(class_1282 source, float amount, CallbackInfoReturnable<Boolean> info) {
        if (this.playerStatsManager.getLevel("defense") == ConfigInit.CONFIG.maxLevel && source.method_5529() != null && this.playerEntity.field_6002.field_9229.nextFloat() <= ConfigInit.CONFIG.defenseReflectChance) {
            source.method_5529().method_5643(source, amount);
        }
        if (this.playerStatsManager.getLevel("agility") == ConfigInit.CONFIG.maxLevel && this.playerEntity.field_6002.field_9229.nextFloat() <= ConfigInit.CONFIG.movementMissChance) {
            info.setReturnValue((Object)false);
        }
    }

    @Inject(method={"eatFood"}, at={@At(value="HEAD")})
    private void eatFoodMixin(class_1937 world, class_1799 stack, CallbackInfoReturnable<class_1799> info) {
        if (stack.method_7909().method_19263() && this.playerStatsManager.getLevel("stamina") == ConfigInit.CONFIG.maxLevel) {
            class_4174 foodComponent = stack.method_7909().method_19264();
            float multiplier = ConfigInit.CONFIG.staminaFoodBonus;
            this.playerEntity.method_7344().method_7585((int)((float)foodComponent.method_19230() * multiplier), foodComponent.method_19231() * multiplier);
        }
    }

    @Override
    public PlayerStatsManager getPlayerStatsManager(class_1657 player) {
        return this.playerStatsManager;
    }

    @Override
    public void increaseKilledMobStat(class_2791 chunk) {
        if (this.killedMobChunk != null && this.killedMobChunk == chunk) {
            ++this.killedMobsInChunk;
        } else {
            this.killedMobChunk = chunk;
            this.killedMobsInChunk = 0;
        }
    }

    @Override
    public boolean allowMobDrop() {
        return this.killedMobsInChunk < 5;
    }
}

