/*
 * Decompiled with CFR 0.152.
 */
package net.levelz.mixin.player;

import com.mojang.authlib.GameProfile;
import net.levelz.access.PlayerStatsManagerAccess;
import net.levelz.init.ConfigInit;
import net.levelz.network.PlayerStatsServerPacket;
import net.levelz.stats.PlayerStatsManager;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3222.class})
public class ServerPlayerEntityMixin {
    PlayerStatsManager playerStatsManager = ((PlayerStatsManagerAccess)((Object)this)).getPlayerStatsManager((class_1657)this);
    private int syncedLevelExperience = -99999999;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void initMixin(MinecraftServer server, class_3218 world, GameProfile profile, CallbackInfo info) {
        class_3222 serverPlayerEntity = (class_3222)this;
        serverPlayerEntity.method_5996(class_5134.field_23716).method_6192(ConfigInit.CONFIG.healthBase + (double)this.playerStatsManager.getLevel("health") * ConfigInit.CONFIG.healthBonus);
        serverPlayerEntity.method_5996(class_5134.field_23719).method_6192(ConfigInit.CONFIG.movementBase + (double)this.playerStatsManager.getLevel("agility") * ConfigInit.CONFIG.movementBonus);
        serverPlayerEntity.method_5996(class_5134.field_23721).method_6192(ConfigInit.CONFIG.attackBase + (double)this.playerStatsManager.getLevel("strength") * ConfigInit.CONFIG.attackBonus);
        serverPlayerEntity.method_5996(class_5134.field_23724).method_6192(ConfigInit.CONFIG.defenseBase + (double)this.playerStatsManager.getLevel("defense") * ConfigInit.CONFIG.defenseBonus);
        serverPlayerEntity.method_5996(class_5134.field_23726).method_6192(ConfigInit.CONFIG.luckBase + (double)this.playerStatsManager.getLevel("luck") * ConfigInit.CONFIG.luckBonus);
    }

    @Inject(method={"addExperience"}, at={@At(value="TAIL")})
    private void addExperienceMixin(int experience, CallbackInfo info) {
        this.syncedLevelExperience = -1;
    }

    @Inject(method={"playerTick"}, at={@At(value="FIELD", target="Lnet/minecraft/server/network/ServerPlayerEntity;totalExperience:I", ordinal=0, shift=At.Shift.BEFORE)})
    private void playerTickMixin(CallbackInfo info) {
        if (this.playerStatsManager.totalLevelExperience != this.syncedLevelExperience) {
            this.syncedLevelExperience = this.playerStatsManager.totalLevelExperience;
            PlayerStatsServerPacket.writeS2CXPPacket(this.playerStatsManager, (class_3222)this);
        }
    }

    @Inject(method={"moveToWorld"}, at={@At(value="FIELD", target="Lnet/minecraft/server/network/ServerPlayerEntity;syncedExperience:I", ordinal=0)})
    @Nullable
    private void moveToWorldMixin(class_3218 destination, CallbackInfoReturnable<class_1297> info) {
        this.syncedLevelExperience = -1;
    }

    @Inject(method={"onSpawn"}, at={@At(value="TAIL")})
    private void onSpawnMixin(CallbackInfo info) {
        PlayerStatsServerPacket.writeS2CSkillPacket(this.playerStatsManager, (class_3222)this);
    }
}

